/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.CustomerRateItem;
import com.ptteng.employment.common.service.CustomerRateItemService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class CustomerRateItemSCAClient implements CustomerRateItemService {

    private CustomerRateItemService customerRateItemService;

    public CustomerRateItemService getCustomerRateItemService() {
        return customerRateItemService;
    }


    public void setCustomerRateItemService(CustomerRateItemService customerRateItemService) {
        this.customerRateItemService = customerRateItemService;
    }


    @Override
    public Long insert(CustomerRateItem customerRateItem) throws ServiceException, ServiceDaoException {

        return customerRateItemService.insert(customerRateItem);


    }


    @Override
    public List<CustomerRateItem> insertList(List<CustomerRateItem> customerRateItemList) throws ServiceException, ServiceDaoException {

        return customerRateItemService.insertList(customerRateItemList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return customerRateItemService.delete(id);


    }


    @Override
    public boolean update(CustomerRateItem customerRateItem) throws ServiceException, ServiceDaoException {

        return customerRateItemService.update(customerRateItem);


    }


    @Override
    public boolean updateList(List<CustomerRateItem> customerRateItemList) throws ServiceException, ServiceDaoException {

        return customerRateItemService.updateList(customerRateItemList);


    }


    @Override
    public CustomerRateItem getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return customerRateItemService.getObjectById(id);


    }


    @Override
    public List<CustomerRateItem> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return customerRateItemService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCustomerRateItemIdsByCustomerRateId(Long customerRateId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return customerRateItemService.getCustomerRateItemIdsByCustomerRateId(customerRateId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCustomerRateItemIdsByCustomerRateId(Long customerRateId) throws ServiceException, ServiceDaoException {

        return customerRateItemService.countCustomerRateItemIdsByCustomerRateId(customerRateId);


    }


    @Override
    public List<Long> getCustomerRateItemIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRateItemService.getCustomerRateItemIds(start, limit);
    }

    @Override
    public Integer countCustomerRateItemIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRateItemService.countCustomerRateItemIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRateItemService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRateItemService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        customerRateItemService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.customerRateItemService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.customerRateItemService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

