/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.AgentServiceRelation;
import com.ptteng.employment.common.service.AgentServiceRelationService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class AgentServiceRelationSCAClient implements AgentServiceRelationService {

    private AgentServiceRelationService agentServiceRelationService;

    public AgentServiceRelationService getAgentServiceRelationService() {
        return agentServiceRelationService;
    }


    public void setAgentServiceRelationService(AgentServiceRelationService agentServiceRelationService) {
        this.agentServiceRelationService = agentServiceRelationService;
    }


    @Override
    public Long insert(AgentServiceRelation agentServiceRelation) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.insert(agentServiceRelation);


    }


    @Override
    public List<AgentServiceRelation> insertList(List<AgentServiceRelation> agentServiceRelationList) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.insertList(agentServiceRelationList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.delete(id);


    }


    @Override
    public boolean update(AgentServiceRelation agentServiceRelation) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.update(agentServiceRelation);


    }


    @Override
    public boolean updateList(List<AgentServiceRelation> agentServiceRelationList) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.updateList(agentServiceRelationList);


    }


    @Override
    public AgentServiceRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.getObjectById(id);


    }


    @Override
    public List<AgentServiceRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getAgentServiceRelationIdsByAgentProviderId(Long agentProviderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.getAgentServiceRelationIdsByAgentProviderId(agentProviderId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getAgentServiceRelationIdByAgentProviderIdAndServiceProviderId(Long agentProviderId, Long serviceProviderId) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.getAgentServiceRelationIdByAgentProviderIdAndServiceProviderId(agentProviderId, serviceProviderId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getAgentServiceRelationIdsByServiceProviderId(Long serviceProviderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.getAgentServiceRelationIdsByServiceProviderId(serviceProviderId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countAgentServiceRelationIdsByAgentProviderId(Long agentProviderId) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.countAgentServiceRelationIdsByAgentProviderId(agentProviderId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countAgentServiceRelationIdsByServiceProviderId(Long serviceProviderId) throws ServiceException, ServiceDaoException {

        return agentServiceRelationService.countAgentServiceRelationIdsByServiceProviderId(serviceProviderId);


    }


    @Override
    public List<Long> getAgentServiceRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return agentServiceRelationService.getAgentServiceRelationIds(start, limit);
    }

    @Override
    public Integer countAgentServiceRelationIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return agentServiceRelationService.countAgentServiceRelationIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return agentServiceRelationService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return agentServiceRelationService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        agentServiceRelationService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.agentServiceRelationService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.agentServiceRelationService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

