package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.NoticeHistory;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface NoticeHistoryService extends BaseDaoService {


    public Long insert(NoticeHistory noticeHistory) throws ServiceException, ServiceDaoException;


    public List<NoticeHistory> insertList(List<NoticeHistory> noticeHistoryList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(NoticeHistory noticeHistory) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<NoticeHistory> noticeHistoryList) throws ServiceException, ServiceDaoException;


    public NoticeHistory getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<NoticeHistory> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countNoticeHistoryIdsByNoticeId(Long noticeId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getNoticeHistoryIdsByNoticeId(Long noticeId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getNoticeHistoryIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countNoticeHistoryIds() throws ServiceException, ServiceDaoException;


}

