package com.ptteng.employment.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "user_flow")
public class UserFlow implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3955902540349248512L;	
	
		
	/**
	 *  线下转账
	 * 
	 */
	public static final Integer TRADE_TYPE_OFFLINE = 1;
    	
	/**
	 *  交易开始
	 * 
	 */
	public static final Integer TRADE_STATE_START = 1;
    	
	/**
	 *  交易成功
	 * 
	 */
	public static final Integer TRADE_STATE_SUCCESS = 2;
    	
	/**
	 *  交易失败
	 * 
	 */
	public static final   Integer TRADE_STATE_FAIL = 3;
	/**
	 *  类型
	 *
	 */
	public static final String TYPE_XINBADA = "XINBADA";

   
   /**
   *  自增长ID
   *
   */
    private  Long id;
	
  
   /**
   *  系统支付单流水号
   *
   */
    private  String transactionId;
	
  
   /**
   *  外部支付单流水号
   *
   */
    private  String outTradeNo;
	
  
   /**
   *  系统订单号
   *
   */
    private  String orderNo;
	
  
   /**
   *  外部订单号
   *
   */
    private  String outOrderNo;
	
  
   /**
   *  交易类型
   *
   */
    private  Integer tradeType;
	
  
   /**
   *  系统交易状态
   *
   */
    private  Integer tradeState;
	
  
   /**
   *  外部状态描述
   *
   */
    private  String outTradeStateDesc;
	
  
   /**
   *  外部交易状态
   *
   */
    private  String outTradeState;
	
  
   /**
   *  结算金额
   *
   */
    private BigDecimal settlementAmount;
	
  
   /**
   *  项目金额
   *
   */
    private  BigDecimal projectAmount;
	
  
   /**
   *  交易完成时间
   *
   */
    private  Long successTime;
	
  
   /**
   *  备注
   *
   */
    private  String tradeMark;
	
  
   /**
   *  项目单号
   *
   */
    private  String projectCode;
	
  
   /**
   *  项目名
   *
   */
    private  String projectName;
	
  
   /**
   *  项目id
   *
   */
    private  Long projectId;
	
  
   /**
   *  发起方名
   *
   */
    private  String sourceName;
	
  
   /**
   *  发起方账户名
   *
   */
    private  String sourceAccountName;
	
  
   /**
   *  发起方账户
   *
   */
    private  String sourceAccountNo;
	
  
   /**
   *  零客银行卡号
   *
   */
    private  String userAccountNo;
	
  
   /**
   *  零客银行
   *
   */
    private  String userBankName;
	
  
   /**
   *  零客名
   *
   */
    private  String userName;
	
  
   /**
   *  零客身份证
   *
   */
    private  String userIdNumber;
	
  
   /**
   *  零客手机号
   *
   */
    private  String userMobile;
	
  
   /**
   *  零客id
   *
   */
    private  Long userId;
	
  
   /**
   *  企业id
   *
   */
    private  Long customerId;
	
  
   /**
   *  企业名
   *
   */
    private  String customerName;
	
  
   /**
   *  服务商id
   *
   */
    private  Long serviceProdiverId;
	
  
   /**
   *  服务商名Z
   *
   */
    private  String serviceProdiverName;
	
  
   /**
   *  类型
   *
   */
    private  String type;
	
  
   /**
   *  创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  创建人
   *
   */
    private  Long createBy;
	
  
   /**
   *  更新人
   *
   */
    private  Long updateBy;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "transaction_id")
	public String getTransactionId() {
		return transactionId;
	}
	
	
	public void setTransactionId(String transactionId) {
		this.transactionId = transactionId;
	}
		 	@Column(name = "out_trade_no")
	public String getOutTradeNo() {
		return outTradeNo;
	}
	
	
	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}
		 	@Column(name = "order_no")
	public String getOrderNo() {
		return orderNo;
	}
	
	
	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}
		 	@Column(name = "out_order_no")
	public String getOutOrderNo() {
		return outOrderNo;
	}
	
	
	public void setOutOrderNo(String outOrderNo) {
		this.outOrderNo = outOrderNo;
	}
		 	@Column(name = "trade_type")
	public Integer getTradeType() {
		return tradeType;
	}
	
	
	public void setTradeType(Integer tradeType) {
		this.tradeType = tradeType;
	}
		 	@Column(name = "trade_state")
	public Integer getTradeState() {
		return tradeState;
	}
	
	
	public void setTradeState(Integer tradeState) {
		this.tradeState = tradeState;
	}
		 	@Column(name = "out_trade_state_desc")
	public String getOutTradeStateDesc() {
		return outTradeStateDesc;
	}
	
	
	public void setOutTradeStateDesc(String outTradeStateDesc) {
		this.outTradeStateDesc = outTradeStateDesc;
	}
		 	@Column(name = "out_trade_state")
	public String getOutTradeState() {
		return outTradeState;
	}
	
	
	public void setOutTradeState(String outTradeState) {
		this.outTradeState = outTradeState;
	}
		 	@Column(name = "settlement_amount")
	public BigDecimal getSettlementAmount() {
		return settlementAmount;
	}
	
	
	public void setSettlementAmount(BigDecimal settlementAmount) {
		this.settlementAmount = settlementAmount;
	}
		 	@Column(name = "project_amount")
	public BigDecimal getProjectAmount() {
		return projectAmount;
	}
	
	
	public void setProjectAmount(BigDecimal projectAmount) {
		this.projectAmount = projectAmount;
	}
		 	@Column(name = "success_time")
	public Long getSuccessTime() {
		return successTime;
	}
	
	
	public void setSuccessTime(Long successTime) {
		this.successTime = successTime;
	}
		 	@Column(name = "trade_mark")
	public String getTradeMark() {
		return tradeMark;
	}
	
	
	public void setTradeMark(String tradeMark) {
		this.tradeMark = tradeMark;
	}
		 	@Column(name = "project_code")
	public String getProjectCode() {
		return projectCode;
	}
	
	
	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}
		 	@Column(name = "project_name")
	public String getProjectName() {
		return projectName;
	}
	
	
	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}
		 	@Column(name = "project_id")
	public Long getProjectId() {
		return projectId;
	}
	
	
	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}
		 	@Column(name = "source_name")
	public String getSourceName() {
		return sourceName;
	}
	
	
	public void setSourceName(String sourceName) {
		this.sourceName = sourceName;
	}
		 	@Column(name = "source_account_name")
	public String getSourceAccountName() {
		return sourceAccountName;
	}
	
	
	public void setSourceAccountName(String sourceAccountName) {
		this.sourceAccountName = sourceAccountName;
	}
		 	@Column(name = "source_account_no")
	public String getSourceAccountNo() {
		return sourceAccountNo;
	}
	
	
	public void setSourceAccountNo(String sourceAccountNo) {
		this.sourceAccountNo = sourceAccountNo;
	}
		 	@Column(name = "user_account_no")
	public String getUserAccountNo() {
		return userAccountNo;
	}
	
	
	public void setUserAccountNo(String userAccountNo) {
		this.userAccountNo = userAccountNo;
	}
		 	@Column(name = "user_bank_name")
	public String getUserBankName() {
		return userBankName;
	}
	
	
	public void setUserBankName(String userBankName) {
		this.userBankName = userBankName;
	}
		 	@Column(name = "user_name")
	public String getUserName() {
		return userName;
	}
	
	
	public void setUserName(String userName) {
		this.userName = userName;
	}
		 	@Column(name = "user_id_number")
	public String getUserIdNumber() {
		return userIdNumber;
	}
	
	
	public void setUserIdNumber(String userIdNumber) {
		this.userIdNumber = userIdNumber;
	}
		 	@Column(name = "user_mobile")
	public String getUserMobile() {
		return userMobile;
	}
	
	
	public void setUserMobile(String userMobile) {
		this.userMobile = userMobile;
	}
		 	@Column(name = "user_id")
	public Long getUserId() {
		return userId;
	}
	
	
	public void setUserId(Long userId) {
		this.userId = userId;
	}
		 	@Column(name = "customer_id")
	public Long getCustomerId() {
		return customerId;
	}
	
	
	public void setCustomerId(Long customerId) {
		this.customerId = customerId;
	}
		 	@Column(name = "customer_name")
	public String getCustomerName() {
		return customerName;
	}
	
	
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
		 	@Column(name = "service_provider_id")
	public Long getServiceProdiverId() {
		return serviceProdiverId;
	}
	
	
	public void setServiceProdiverId(Long serviceProdiverId) {
		this.serviceProdiverId = serviceProdiverId;
	}
		 	@Column(name = "service_provider_name")
	public String getServiceProdiverName() {
		return serviceProdiverName;
	}
	
	
	public void setServiceProdiverName(String serviceProdiverName) {
		this.serviceProdiverName = serviceProdiverName;
	}
		 	@Column(name = "type")
	public String getType() {
		return type;
	}
	
	
	public void setType(String type) {
		this.type = type;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
    public static Integer OutTradeStateToTradeStateByXinbada(String outTradeState) {
        //待校验=0，校验中=1，校验通过待付款、付款失败、订单驳回=2，付款成功=30， 下发成功=50，下发失败=-10
        if ("50".equals(outTradeState)) {
            //付款成功
            return UserFlow.TRADE_STATE_SUCCESS;
        } else if ("-1".equals(outTradeState)||"-10".equals(outTradeState)||"2".equals(outTradeState)||"-3".equals(outTradeState)) {
            //付款失败
            return UserFlow.TRADE_STATE_FAIL;
        } else {
            //薪八达付款处理中
            return UserFlow.TRADE_STATE_START;
        }
    }

}

