package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "notice")
public class Notice implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 341533967533737984L;


    /**
     * 公告
     */
    public static final Integer TYPE_NOTICE = 1;

    /**
     * 弹窗
     */
    public static final Integer TYPE_POP = 2;

    /**
     * 未发送
     */
    public static final Integer STATUS_UNSENT = 0;

    /**
     * 已发送
     */
    public static final Integer STATUS_SENT_SUCCESS = 1;

    /**
     * 发送失败
     */
    public static final Integer STATUS_SENT_FAIL = 2;

    /**
     * 零客
     */
    public static final String GROUP_TYPE_INDIVIDUAL = "INDIVIDUAL";

    /**
     * 客户
     */
    public static final String GROUP_TYPE_CUSTOMER = "CUSTOMER";

    /**
     * 自定义
     */
    public static final String GROUP_TYPE_ASSIGN = "ASSIGN";

    /**
     * 全部
     */
    public static final String GROUP_TYPE_ALL = "ALL";


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 发送时间
     */
    private Long sendTime;


    /**
     * 公告标题
     */
    private String title;


    /**
     * 公告内容
     */
    private String content;


    /**
     * 接受组群
     */
    private String groupType;


    /**
     * 消息类型
     */
    private Integer type;


    /**
     * 附件
     */
    private String attachment;


    /**
     * 状态
     */
    private Integer status;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "send_time")
    public Long getSendTime() {
        return sendTime;
    }


    public void setSendTime(Long sendTime) {
        this.sendTime = sendTime;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }


    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "group_type")
    public String getGroupType() {
        return groupType;
    }


    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "attachment")
    public String getAttachment() {
        return attachment;
    }


    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

