package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "invoice")
public class Invoice implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1708166336777187328L;


    /**
     * 待审核
     */
    public static final Integer STATUS_CHECK_PENDING = 1;

    /**
     * 开具中
     */
    public static final Integer STATUS_IN_PROCESS = 2;

    /**
     * 已开具
     */
    public static final Integer STATUS_COMPLETE = 3;

    /**
     * 已驳回
     */
    public static final Integer STATUS_REJECTED = 0;

    /**
     * 待邮寄
     */
    public static final Integer EXPRESS_STATUS_PENDING = 1;

    /**
     * 已邮寄
     */
    public static final Integer EXPRESS_STATUS_COMPLETE = 2;

    /**
     * 普票
     */
    public static final Integer TYPE_COMMON = 1;

    /**
     * 专票
     */
    public static final Integer TYPE_SPECIAL = 2;

    /**
     * 差额票
     */
    public static final Integer TYPE_BALANCE = 3;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 客户id
     */
    private Long customerId;


    /**
     * 申请开票金额
     */
    private BigDecimal expectedAmount;


    /**
     * 开票类目
     */
    private String invoiceCategory;


    /**
     * 发票类型
     */
    private Integer type;


    /**
     * 金额
     */
    private BigDecimal amount;


    /**
     * 发票代码
     */
    private String invoiceCode;


    /**
     * 发票号
     */
    private String invoiceNumber;


    /**
     * 价税合计
     */
    private BigDecimal totalAmount;


    /**
     * 发票图片
     */
    private String invoicePic;


    /**
     * 开具时间
     */
    private Long completeTime;


    /**
     * 税额
     */
    private BigDecimal taxAmount;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 发票订单id
     */
    private Long invoiceOrderId;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "customer_id")
    public Long getCustomerId() {
        return customerId;
    }


    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @Column(name = "expected_amount")
    public BigDecimal getExpectedAmount() {
        return expectedAmount;
    }


    public void setExpectedAmount(BigDecimal expectedAmount) {
        this.expectedAmount = expectedAmount;
    }

    @Column(name = "invoice_category")
    public String getInvoiceCategory() {
        return invoiceCategory;
    }


    public void setInvoiceCategory(String invoiceCategory) {
        this.invoiceCategory = invoiceCategory;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "amount")
    public BigDecimal getAmount() {
        return amount;
    }


    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Column(name = "invoice_code")
    public String getInvoiceCode() {
        return invoiceCode;
    }


    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    @Column(name = "invoice_number")
    public String getInvoiceNumber() {
        return invoiceNumber;
    }


    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    @Column(name = "total_amount")
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }


    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @Column(name = "invoice_pic")
    public String getInvoicePic() {
        return invoicePic;
    }


    public void setInvoicePic(String invoicePic) {
        this.invoicePic = invoicePic;
    }

    @Column(name = "complete_time")
    public Long getCompleteTime() {
        return completeTime;
    }


    public void setCompleteTime(Long completeTime) {
        this.completeTime = completeTime;
    }

    @Column(name = "tax_amount")
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }


    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "invoice_order_id")
    public Long getInvoiceOrderId() {
        return invoiceOrderId;
    }


    public void setInvoiceOrderId(Long invoiceOrderId) {
        this.invoiceOrderId = invoiceOrderId;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

