package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "bank")
public class Bank implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4593262070495704064L;
    /**
     * 已校验
     */
    public static final Integer STATUS_VALIDATION_YES = 1;

    /**
     * 未校验
     */
    public static final Integer STATUS_VALIDATION_NO = 0;
    public static final Integer STATUS_DISABLE = 0;
    public static final Integer STATUS_ENABLE = 1;


    /**
     * 通过校验结果
     */
    public static final String MESSAGE = "通过校验";

    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 银行卡号
     */
    private String account;


    /**
     * 银行名称
     */
    private String name;


    /**
     * 银行开户地址
     */
    private String address;


    /**
     * 零客ID
     */
    private Long userId;

    /**
     * 校验状态
     */
    private Integer validationStatus;


    /**
     * 校验结果
     */
    private String validationMessage;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;

    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 状态
     */
    private Integer status;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "account")
    public String getAccount() {
        return account;
    }


    public void setAccount(String account) {
        this.account = account;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "address")
    public String getAddress() {
        return address;
    }


    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }


    public void setUserId(Long userId) {
        this.userId = userId;
    }


    @Column(name = "validation_status")
    public Integer getValidationStatus() {
        return validationStatus;
    }
    public void setValidationStatus(Integer validationStatus) {
        this.validationStatus = validationStatus;
    }


    @Column(name = "validation_message")
    public String getValidationMessage() {
        return validationMessage;
    }
    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }


    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }
    @Column(name = "customer_id")
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

