package com.ptteng.employment.common.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "agent_provider")
public class AgentProvider implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 653631261733229568L;

    /**
     * 停用
     */
    public static final Integer STATUS_DISABLE = 0;

    /**
     * 启用
     */
    public static final Integer STATUS_ENABLE = 1;
    /**
     * 通过
     */
    public static final Integer VERIFY_STATUS_TRUE = 1;

    /**
     * 未通过
     */
    public static final Integer VERIFY_STATUS_FAIL = 0;
    /**
     * 次月25
     */
    public static final Integer INTERVAL_25 = 1;

    /**
     * 次次月25
     */
    public static final Integer INTERVAL_2_25 = 2;

    /**
     * 个人
     */
    public static final Integer TYPE_PERSON = 2;

    /**
     * 公司
     */
    public static final Integer TYPE_COMPANY = 1;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 代理商名称
     */
    private String name;


    /**
     * 代理商类型
     */
    private Integer type;


    /**
     * 信用代码
     */
    private String creditCode;


    /**
     * 法人身份证号
     */
    private String legalPersonId;


    /**
     * 联系人姓名
     */
    private String legalPersonName;


    /**
     * 核验状态
     */
    private Integer verifyStatus;
    /**
    /**
     * 联系方式
     */
    private String mobile;


    /**
     * 邮箱
     */
    private String email;


    /**
     * 营业执照
     */
    private String businessLicense;


    /**
     * 身份证照片
     */
    private String cardPhotos;


    /**
     * 合同
     */
    private String contract;


    /**
     * 代理级别
     */
    private Integer agentLevel;


    /**
     * 状态
     */
    private Integer status;


    /**
     * 结算周期
     */
    private Integer settlementInterval;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "credit_code")
    public String getCreditCode() {
        return creditCode;
    }


    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    @Column(name = "legal_person_id")
    public String getLegalPersonId() {
        return legalPersonId;
    }


    public void setLegalPersonId(String legalPersonId) {
        this.legalPersonId = legalPersonId;
    }

    @Column(name = "legal_person_name")
    public String getLegalPersonName() {
        return legalPersonName;
    }


    public void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "email")
    public String getEmail() {
        return email;
    }


    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name = "business_license")
    public String getBusinessLicense() {
        return businessLicense;
    }


    public void setBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense;
    }

    @Column(name = "card_photos")
    public String getCardPhotos() {
        return cardPhotos;
    }


    public void setCardPhotos(String cardPhotos) {
        this.cardPhotos = cardPhotos;
    }

    @Column(name = "contract")
    public String getContract() {
        return contract;
    }


    public void setContract(String contract) {
        this.contract = contract;
    }

    @Column(name = "agent_level")
    public Integer getAgentLevel() {
        return agentLevel;
    }


    public void setAgentLevel(Integer agentLevel) {
        this.agentLevel = agentLevel;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "settlement_interval")
    public Integer getSettlementInterval() {
        return settlementInterval;
    }


    public void setSettlementInterval(Integer settlementInterval) {
        this.settlementInterval = settlementInterval;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }
    @Column(name = "verify_status")
    public Integer getVerifyStatus() {
        return verifyStatus;
    }


    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }
    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

