package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.User;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface UserService extends BaseDaoService {


    public Long insert(User user) throws ServiceException, ServiceDaoException;


    public List<User> insertList(List<User> userList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(User user) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<User> userList) throws ServiceException, ServiceDaoException;


    public User getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<User> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIdsByIdNumberAndStatus(String idNumber, Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIdsByCustomerIdAndStatus(Long customerId, Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIdsByIdNumber(String idNumber) throws ServiceException, ServiceDaoException;

    public Long getUserIdByIdNumberAndCustomerId(String idNumber, Long customerId) throws ServiceException, ServiceDaoException;
    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserIdByOpenIdAndMobile(String openId,String mobile) throws ServiceException, ServiceDaoException;
    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserIdByOpenId(String openId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIdsByCustomerId(Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIdsByIdNumberAndStatus(String idNumber, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIdsByCustomerIdAndStatus(Long customerId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIdsByIdNumber(String idNumber, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIds() throws ServiceException, ServiceDaoException;


}

