package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.CustomerRate;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface CustomerRateService extends BaseDaoService {


    public Long insert(CustomerRate customerRate) throws ServiceException, ServiceDaoException;


    public List<CustomerRate> insertList(List<CustomerRate> customerRateList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(CustomerRate customerRate) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<CustomerRate> customerRateList) throws ServiceException, ServiceDaoException;


    public CustomerRate getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<CustomerRate> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCustomerRateIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerRateIdsByCustomerId(Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerRateIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCustomerRateIds() throws ServiceException, ServiceDaoException;


}

