package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.AgentServiceRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface AgentServiceRelationService extends BaseDaoService {


    public Long insert(AgentServiceRelation agentServiceRelation) throws ServiceException, ServiceDaoException;


    public List<AgentServiceRelation> insertList(List<AgentServiceRelation> agentServiceRelationList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(AgentServiceRelation agentServiceRelation) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<AgentServiceRelation> agentServiceRelationList) throws ServiceException, ServiceDaoException;


    public AgentServiceRelation getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<AgentServiceRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countAgentServiceRelationIdsByAgentProviderId(Long agentProviderId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countAgentServiceRelationIdsByServiceProviderId(Long serviceProviderId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getAgentServiceRelationIdsByAgentProviderId(Long agentProviderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getAgentServiceRelationIdByAgentProviderIdAndServiceProviderId(Long agentProviderId, Long serviceProviderId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getAgentServiceRelationIdsByServiceProviderId(Long serviceProviderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getAgentServiceRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countAgentServiceRelationIds() throws ServiceException, ServiceDaoException;


}

