package com.ptteng.employment.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.employment.common.model.AgentProviderRate;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface AgentProviderRateService extends BaseDaoService {

	



   		   
		
		public Long insert(AgentProviderRate agentProviderRate)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<AgentProviderRate> insertList(List<AgentProviderRate> agentProviderRateList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(AgentProviderRate agentProviderRate)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<AgentProviderRate> agentProviderRateList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public AgentProviderRate getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<AgentProviderRate> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAgentProviderRateIdsByAgentProviderIdAndServiceProviderId(Long agentProviderId, Long serviceProviderId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAgentProviderRateIdsByServiceProviderId(Long serviceProviderId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAgentProviderRateIdsByAgentProviderId(Long agentProviderId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAgentProviderRateIdsByAgentProviderIdAndServiceProviderId(Long agentProviderId, Long serviceProviderId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAgentProviderRateIdsByServiceProviderId(Long serviceProviderId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAgentProviderRateIdsByAgentProviderId(Long agentProviderId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getAgentProviderRateIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countAgentProviderRateIds() throws ServiceException, ServiceDaoException;
	

}

