package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "service_provider")
public class ServiceProvider implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2183012028558981120L;


    /**
     * 自然人
     */
    public static final Integer TEX_NATURAL = 1;

    /**
     * 个体工商户
     */
    public static final Integer TEX_BUSINESSMAN = 2;

    /**
     * 法人
     */
    public static final Integer TEX_LEGAL = 3;

    /**
     * 上架
     */
    public static final Integer STATUS_UP = 1;

    /**
     * 下架
     */
    public static final Integer STATUS_DOWN = 0;

    /**
     * 认证通过
     */
    public static final Integer VERIFY_STATUS_SUCCESS = 1;

    /**
     * 认证失败
     */
    public static final Integer VERIFY_STATUS_FAIL = 0;

    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 名称
     */
    private String name;


    /**
     * 信用代码
     */
    private String creditCode;


    /**
     * 法人姓名
     */
    private String legalPerson;


    /**
     * 法人证件号码
     */
    private String legalPersonId;


    /**
     * 联系人
     */
    private String contactPerson;


    /**
     * 联系人号码
     */
    private String contactPersonMobile;


    /**
     * 营业执照
     */
    private String licenseFiles;


    /**
     * 委托代征资质
     */
    private String qualificationFiles;


    /**
     * 法人身份证照片
     */
    private String contactPersonFiles;


    /**
     * 其他附件
     */
    private String otherFiles;


    /**
     * 服务费率
     */
    private String serviceRates;


    /**
     *
     */
    private String limitPerDay;


    /**
     * 单笔限额
     */
    private String singleLimit;


    /**
     * 单人单月限额
     */
    private String limitPerMonth;


    /**
     * 单人年度限额
     */
    private String limitPerYear;


    /**
     * 企业名称
     */
    private String companyName;


    /**
     * 账号
     */
    private String companyAccount;


    /**
     * 纳税人类型
     */
    private Integer taxpayerType;


    /**
     * 纳税人识别号称
     */
    private String taxpayerNumber;


    /**
     * 电话
     */
    private String companyPhone;


    /**
     * 开户行
     */
    private String companyBank;


    /**
     * 地址
     */
    private String companyAddress;


    /**
     * 上下架状态
     */
    private Integer status;

    /**
     * 认证状态
     */
    private Integer verifyStatus;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * e签宝账号id
     */
    private String esignAccountId;
    /**
     * e签宝印章id
     */
    private String esignSealId;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "credit_code")
    public String getCreditCode() {
        return creditCode;
    }


    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    @Column(name = "legal_person")
    public String getLegalPerson() {
        return legalPerson;
    }


    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }

    @Column(name = "legal_person_id")
    public String getLegalPersonId() {
        return legalPersonId;
    }


    public void setLegalPersonId(String legalPersonId) {
        this.legalPersonId = legalPersonId;
    }

    @Column(name = "contact_person")
    public String getContactPerson() {
        return contactPerson;
    }


    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    @Column(name = "contact_person_mobile")
    public String getContactPersonMobile() {
        return contactPersonMobile;
    }


    public void setContactPersonMobile(String contactPersonMobile) {
        this.contactPersonMobile = contactPersonMobile;
    }

    @Column(name = "license_files")
    public String getLicenseFiles() {
        return licenseFiles;
    }


    public void setLicenseFiles(String licenseFiles) {
        this.licenseFiles = licenseFiles;
    }

    @Column(name = "qualification_files")
    public String getQualificationFiles() {
        return qualificationFiles;
    }


    public void setQualificationFiles(String qualificationFiles) {
        this.qualificationFiles = qualificationFiles;
    }

    @Column(name = "contact_person_files")
    public String getContactPersonFiles() {
        return contactPersonFiles;
    }


    public void setContactPersonFiles(String contactPersonFiles) {
        this.contactPersonFiles = contactPersonFiles;
    }

    @Column(name = "other_files")
    public String getOtherFiles() {
        return otherFiles;
    }


    public void setOtherFiles(String otherFiles) {
        this.otherFiles = otherFiles;
    }

    @Column(name = "service_rates")
    public String getServiceRates() {
        return serviceRates;
    }


    public void setServiceRates(String serviceRates) {
        this.serviceRates = serviceRates;
    }

    @Column(name = "limit_per_day")
    public String getLimitPerDay() {
        return limitPerDay;
    }


    public void setLimitPerDay(String limitPerDay) {
        this.limitPerDay = limitPerDay;
    }

    @Column(name = "single_limit")
    public String getSingleLimit() {
        return singleLimit;
    }


    public void setSingleLimit(String singleLimit) {
        this.singleLimit = singleLimit;
    }

    @Column(name = "limit_per_month")
    public String getLimitPerMonth() {
        return limitPerMonth;
    }


    public void setLimitPerMonth(String limitPerMonth) {
        this.limitPerMonth = limitPerMonth;
    }

    @Column(name = "limit_per_year")
    public String getLimitPerYear() {
        return limitPerYear;
    }


    public void setLimitPerYear(String limitPerYear) {
        this.limitPerYear = limitPerYear;
    }

    @Column(name = "company_name")
    public String getCompanyName() {
        return companyName;
    }


    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Column(name = "company_account")
    public String getCompanyAccount() {
        return companyAccount;
    }


    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    @Column(name = "taxpayer_type")
    public Integer getTaxpayerType() {
        return taxpayerType;
    }


    public void setTaxpayerType(Integer taxpayerType) {
        this.taxpayerType = taxpayerType;
    }

    @Column(name = "taxpayer_number")
    public String getTaxpayerNumber() {
        return taxpayerNumber;
    }


    public void setTaxpayerNumber(String taxpayerNumber) {
        this.taxpayerNumber = taxpayerNumber;
    }

    @Column(name = "company_phone")
    public String getCompanyPhone() {
        return companyPhone;
    }


    public void setCompanyPhone(String companyPhone) {
        this.companyPhone = companyPhone;
    }

    @Column(name = "company_bank")
    public String getCompanyBank() {
        return companyBank;
    }


    public void setCompanyBank(String companyBank) {
        this.companyBank = companyBank;
    }

    @Column(name = "company_address")
    public String getCompanyAddress() {
        return companyAddress;
    }


    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    @Column(name = "verify_status")
    public Integer getVerifyStatus() {
        return verifyStatus;
    }


    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "esign_account_id")
    public String getEsignAccountId() {
        return esignAccountId;
    }

    public void setEsignAccountId(String esignAccountId) {
        this.esignAccountId = esignAccountId;
    }
    @Column(name = "esign_seal_id")
    public String getEsignSealId() {
        return esignSealId;
    }

    public void setEsignSealId(String esignSealId) {
        this.esignSealId = esignSealId;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

