package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "project_user")
public class ProjectUser implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 805143647315714048L;


    /**
     *
     */
    public static final Integer STATUS_COLLECTED= 1;

    /**
     * 未参与
     */
    public static final Integer STATUS_NOT_COLLECTED = 0;
    public static final Integer STATUS_REJECTED = 2;

    /**
     * 已签约
     */
    public static final Integer SIGN_STATUS_YES= 1;


    /**
     * 未签约
     */
    public static final Integer SIGN_STATUS_NO = 0;

    /**
     * 已到账
     */
    public static final Integer AGREEMENT_STATUS_FINISH = 3;

    /**
     * 付款中
     */
    public static final Integer AGREEMENT_STATUS_PAYMENT_IN = 1;

    /**
     * 未到账
     */
    public static final Integer AGREEMENT_STATUS_processing_ = 2;


    public static final Integer AMOUNT_TYPE_PROJECT=1;
    public static final Integer AMOUNT_TYPE_SETTLEMENTAMOUNT=2;
    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 零客id
     */
    private Long userId;


    /**
     * 项目id
     */
    private Long projectId;


    /**
     * 协议url
     */
    private String agreementUrl;


    /**
     * 签约状态
     */
    private Integer signStatus;


    /**
     * 参与状态
     */
    private Integer status;


    /**
     * 结束数量
     */
    private Integer resultTotal;


    /**
     * 项目金额
     */
    private BigDecimal projectAmount;


    /**
     * 失败原因
     */
    private String failDesc;


    /**
     * 结算金额
     */
    private BigDecimal settlementAmount;


    /**
     * 结算状态
     */
    private Integer agreementStatus;


    /**
     * 领取时间
     */
    private Long signTime;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }


    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "project_id")
    public Long getProjectId() {
        return projectId;
    }


    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Column(name = "agreement_url")
    public String getAgreementUrl() {
        return agreementUrl;
    }


    public void setAgreementUrl(String agreementUrl) {
        this.agreementUrl = agreementUrl;
    }

    @Column(name = "sign_status")
    public Integer getSignStatus() {
        return signStatus;
    }


    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "result_total")
    public Integer getResultTotal() {
        return resultTotal;
    }


    public void setResultTotal(Integer resultTotal) {
        this.resultTotal = resultTotal;
    }

    @Column(name = "project_amount")
    public BigDecimal getProjectAmount() {
        return projectAmount;
    }


    public void setProjectAmount(BigDecimal projectAmount) {
        this.projectAmount = projectAmount;
    }

    @Column(name = "fail_desc")
    public String getFailDesc() {
        return failDesc;
    }


    public void setFailDesc(String failDesc) {
        this.failDesc = failDesc;
    }

    @Column(name = "settlement_amount")
    public BigDecimal getSettlementAmount() {
        return settlementAmount;
    }


    public void setSettlementAmount(BigDecimal settlementAmount) {
        this.settlementAmount = settlementAmount;
    }

    @Column(name = "agreement_status")
    public Integer getAgreementStatus() {
        return agreementStatus;
    }


    public void setAgreementStatus(Integer agreementStatus) {
        this.agreementStatus = agreementStatus;
    }

    @Column(name = "sign_time")
    public Long getSignTime() {
        return signTime;
    }


    public void setSignTime(Long signTime) {
        this.signTime = signTime;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

