package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "notice_history")
public class NoticeHistory implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 8120280157029089280L;


    /**
     * 客户
     */
    public static final String USER_TYPE_CUSTOMER = "CUSTOMER";

    /**
     * 零客
     */
    public static final String USER_TYPE_INDIVIDUAL = "INDIVIDUAL";

    /**
     * 未读
     */
    public static final Integer STATUS_UNREAD = 0;

    /**
     * 已读
     */
    public static final Integer STATUS_READ = 1;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 公告id
     */
    private Long noticeId;


    /**
     * 对象id
     */
    private Long userId;


    /**
     * 对象类型
     */
    private Integer userType;


    /**
     * 状态
     */
    private Integer status;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "notice_id")
    public Long getNoticeId() {
        return noticeId;
    }


    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }


    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "user_type")
    public Integer getUserType() {
        return userType;
    }


    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

