package com.ptteng.credit.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "bank_card_application")
public class BankCardApplication implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2128454207738839040L;

    /**
     * 银行上下架状态：0=下架
     */
    public static final Integer NOT_SHELF = 0;

    /**
     * 银行上下架状态：1=上架
     */
    public static final Integer SHELF = 1;

    /**
     * 申请量加1
     */
    public static final Integer PLUS_ONE = 1;

    private Long id;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 申请量
     */
    private Integer applicationAmount = 0;

    /**
     * 图片
     */
    private String img = "";

    /**
     * 优惠亮点
     */
    private String offerHighlights = "";

    /**
     * 分佣金额
     */
    private BigDecimal commissionAmount = new BigDecimal("0");

    /**
     * 信用卡申请跳转链接
     */
    private String url = "";


    private Integer status = 0;


    private Long createAt;


    private Long updateAt;


    private Long createBy = 0L;


    private Long updateBy = 0L;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "bank_name")
    public String getBankName() {
        return bankName;
    }


    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Column(name = "application_amount")
    public Integer getApplicationAmount() {
        return applicationAmount;
    }


    public void setApplicationAmount(Integer applicationAmount) {
        this.applicationAmount = applicationAmount;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "offer_highlights")
    public String getOfferHighlights() {
        return offerHighlights;
    }


    public void setOfferHighlights(String offerHighlights) {
        this.offerHighlights = offerHighlights;
    }

    @Column(name = "commission_amount")
    public BigDecimal getCommissionAmount() {
        return commissionAmount;
    }


    public void setCommissionAmount(BigDecimal commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    @Column(name = "url")
    public String getUrl() {
        return url;
    }


    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

