package com.ptteng.credit.user.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "application_recod")
public class ApplicationRecod implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3103407411455452160L;

    /**
     * 申请状态 待在查  （申请中）
     */
    public static final Integer STAYING_IN_CHECK = 1;

    /**
     * 申请状态 已完成
     */
    public static final Integer COMPLETED = 2;

    /**
     * 申请状态 未通过
     */
    public static final Integer DID_NOT_PASS = 3;

    /**
     * 审核状态 人工审核
     */
    public static final Integer MANUAL_REVIEW = 4;

    /**
     * 申请状态 初始化 （申请中）
     */
    public static final Integer INIT = 0;

    /**
     * 0=查全部
     */
    public static final int ALL = 0;

    /**
     * 2=已完成
     */
    public static final int COMPLETED_INT = 2;

    /**
     * 1=待在查
     */
    public static final int STAYING_IN_CHECK_INT = 1;

    /**
     * ，3=未通过
     */
    public static final int DID_NOT_PASS_INT = 3;

    /**
     * 一天时间戳
     */
    public static final Long DAY = 24 * 60 * 60 * 1000L;


    private Long id;


    private Long uid;

    private Long bankId;

    private String mobile;

    private String name;

    private Integer status;

    private String bankName;

    private String number;

    private String IDCard;

    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "bank_id")
    public Long getBankId() {
        return bankId;
    }

    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    @Column(name = "bank_name")
    public String getBankName() {
        return bankName;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Column(name = "number")
    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @Column(name = "id_card")
    public String getIDCard() {
        return IDCard;
    }

    public void setIDCard(String IDCard) {
        this.IDCard = IDCard;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

