package com.ptteng.credit.user.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.credit.user.model.User;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserService extends BaseDaoService {


    public Long insert(User user) throws ServiceException, ServiceDaoException;


    public List<User> insertList(List<User> userList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(User user) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<User> userList) throws ServiceException, ServiceDaoException;


    public User getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<User> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    public List<Long> getTotalSub(int position, Long uid) throws ServiceException, ServiceDaoException;


    public List<Long> getTotalSubByPage(int position, Long uid, String number, Integer page,
                                        Integer size, boolean isPage) throws ServiceException, ServiceDaoException;

    public List<Long> testUser()throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserIdByOpenID(String openID) throws ServiceException, ServiceDaoException;

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long>  getUserIdsByIDCard(String IDCard,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long>  getUserIdsByUnionid(String unionid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;



    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long>  getUserIdsByInvitePeopleId(Long invitePeopleId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserIdBySuperId(Long superId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserIdByMobile(String mobile) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIds() throws ServiceException, ServiceDaoException;


    /**
     * 用户升级
     * @param user
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer upgradeByUser(User user,Long uid) throws ServiceException, ServiceDaoException;

}

