package com.ptteng.credit.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "withdrawals_record")
public class WithdrawalsRecord implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4506392780599122944L;

    /**
     * 提现审核 通过
     */
    public static final Integer PASS = 1;

    /**
     * 提现审核 不通过
     */
    public static final Integer FAIL = 2;

    /**
     * 提现审核 未审核
     */
    public static final Integer UNREVIEWED = 3;

    /**
     * 查询类型 1=提现记录
     */
    public static final Integer WITHDRAW = 1;

    /**
     * 查询类型 2=提现审核
     */
    public static final Integer COMMISSION = 2;


    private Long id;

    /**
     * 当日提现次数限制
     */
    public static final Integer NUMBER_LIMIT = 5;

    /**
     * 当日提现金额限制
     */
    public static final BigDecimal AMOUNT_LIMIT = new BigDecimal("200");

    /**
     * 当日提现金额超过限制
     */
    public static final Integer AMOUNT_EXCEED_LIMIT = -1;

    public static final Integer LESS_THAN_LIMIT = 1;

    /**
     * 初始化
     */
    public static final Integer INIT = 1;

    /**
     * 流水号
     */
    private String serialNumber;


    private Long uid;


    /**
     * 今日提现次数
     */
    private Integer todayWithdrawals;

    /**
     * 今日提现金额
     */
    private BigDecimal cashTodayAmount;

    /**
     * 本次提现金额
     */
    private BigDecimal cashWithdrawalAmount;

    /**
     * 申请时间
     */
    private Long applicationTime;

    /**
     * 到账时间
     */
    private Long timeOfArrival = 0L;


    private Integer status = 0;


    private Long createAt;


    private Long updateAt;


    private Long createBy = 0L;


    private Long updateBy = 0L;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "serial_number")
    public String getSerialNumber() {
        return serialNumber;
    }


    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "today_withdrawals")
    public Integer getTodayWithdrawals() {
        return todayWithdrawals;
    }


    public void setTodayWithdrawals(Integer todayWithdrawals) {
        this.todayWithdrawals = todayWithdrawals;
    }

    @Column(name = "cash_today_amount")
    public BigDecimal getCashTodayAmount() {
        return cashTodayAmount;
    }


    public void setCashTodayAmount(BigDecimal cashTodayAmount) {
        this.cashTodayAmount = cashTodayAmount;
    }

    @Column(name = "cash_withdrawal_amount")
    public BigDecimal getCashWithdrawalAmount() {
        return cashWithdrawalAmount;
    }


    public void setCashWithdrawalAmount(BigDecimal cashWithdrawalAmount) {
        this.cashWithdrawalAmount = cashWithdrawalAmount;
    }

    @Column(name = "application_time")
    public Long getApplicationTime() {
        return applicationTime;
    }


    public void setApplicationTime(Long applicationTime) {
        this.applicationTime = applicationTime;
    }

    @Column(name = "time_of_arrival")
    public Long getTimeOfArrival() {
        return timeOfArrival;
    }


    public void setTimeOfArrival(Long timeOfArrival) {
        this.timeOfArrival = timeOfArrival;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

