/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.util.cft;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Signature {
    private static final Log log = LogFactory.getLog(Signature.class);
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String generateMAC(Map<String, String> params, String commKey, String mrch_cert, String mrch_cert_pwd) {
        log.info((Object)(" generateMAC  start = mrch_cert =  " + mrch_cert + " mrch_cert_pwd = " + mrch_cert_pwd));
        if (params.containsKey("sign_type") && params.get("sign_type").equals("RSA")) {
            log.info((Object)"  sign_type  =  RSA ");
            try {
                PrivateKey privKey = Signature.readPrivateKey(mrch_cert, mrch_cert_pwd);
                log.info((Object)("  privKey  =  privKey " + privKey));
                java.security.Signature signature = java.security.Signature.getInstance("SHA1WithRSA");
                signature.initSign(privKey);
                signature.update(Signature.generateParamStr(params).getBytes());
                byte[] signed = signature.sign();
                String mac = new BASE64Encoder().encode(signed).replaceAll(System.getProperty("line.separator"), "");
                return mac;
            }
            catch (Exception e) {
                log.info((Object)"   error SIGNATURE_RSA_CERT_ERROR ");
                return "SIGNATURE_RSA_CERT_ERROR";
            }
        }
        log.info((Object)"  sign_type  =  SAH1 ");
        return Signature.encryptBySHA(Signature.generateParamStr(params) + "&" + commKey);
    }

    private static String encryptBySHA(String content) {
        if (content == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] output = md.digest(content.getBytes("UTF-8"));
            return Signature.bytesToHexStr(output);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String bytesToHexStr(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(hexChar[(bytes[i] & 0xF0) >>> 4]);
            sb.append(hexChar[bytes[i] & 0xF]);
        }
        return sb.toString();
    }

    private static String generateParamStr(Map<String, String> params) {
        ArrayList<String> paramList = new ArrayList<String>();
        for (String key : params.keySet()) {
            if ("mac".equals(key)) continue;
            String val = params.get(key);
            paramList.add(key + "=" + val);
        }
        if (paramList.size() == 0) {
            return null;
        }
        Collections.sort(paramList);
        StringBuilder sb = new StringBuilder();
        sb.append((String)paramList.get(0));
        for (int i = 1; i < paramList.size(); ++i) {
            sb.append("&").append((String)paramList.get(i));
        }
        return sb.toString();
    }

    public static boolean verifyMAC(Map<String, String> params, String commKey, String cert) {
        if (!params.containsKey("mac")) {
            return false;
        }
        String mac = params.get("mac");
        log.info((Object)(" mac = " + mac));
        if (params.containsKey("sign_type") && params.get("sign_type").equals("RSA")) {
            if (mac == null) {
                return false;
            }
            log.info((Object)" sign_type =  RSA  ");
            try {
                PublicKey pubKey = Signature.readPublicKey(cert);
                java.security.Signature signature = java.security.Signature.getInstance("SHA1WithRSA");
                signature.initVerify(pubKey);
                signature.update(Signature.generateParamStr(params).getBytes());
                byte[] bmac = new BASE64Decoder().decodeBuffer(mac);
                Boolean result = signature.verify(bmac);
                log.info((Object)("  result = " + result));
                return result;
            }
            catch (Exception e) {
                return false;
            }
        }
        return mac != null && mac.equals(Signature.generateMAC(params, commKey, "", ""));
    }

    public static Map<String, String> jsonToMap(String jsonStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        JSONObject json = JSONObject.parseObject((String)jsonStr);
        for (String key : json.keySet()) {
            String value = json.get((Object)key).toString();
            map.put(key, value);
        }
        return map;
    }

    private static PrivateKey readPrivateKey(String certPath, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        InputStream is = null;
        File file = new File(certPath);
        if (file.exists()) {
            is = new FileInputStream(certPath);
        } else {
            Class<Signature> clz = Signature.class;
            ClassLoader cl = clz.getClassLoader();
            URL url = cl.getResource(certPath);
            if (url == null) {
                throw new FileNotFoundException();
            }
            is = cl.getResourceAsStream(certPath);
        }
        keyStore.load(is, password == null ? null : password.toCharArray());
        if (is != null) {
            is.close();
        }
        return (PrivateKey)keyStore.getKey(keyStore.aliases().nextElement(), password == null ? null : password.toCharArray());
    }

    private static PublicKey readPublicKey(String certPath) throws CertificateException, IOException {
        File file = new File(certPath);
        InputStream is = null;
        if (file.exists()) {
            is = new FileInputStream(certPath);
        } else {
            Class<Signature> clz = Signature.class;
            ClassLoader cl = clz.getClassLoader();
            URL url = cl.getResource(certPath);
            if (url == null) {
                throw new FileNotFoundException();
            }
            is = cl.getResourceAsStream(certPath);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        if (is != null) {
            is.close();
        }
        return cert.getPublicKey();
    }
}

