/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Student;
import com.ptteng.codinglord.common.service.StudentService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StudentServiceImpl
extends BaseDaoServiceImpl
implements StudentService {
    private static final Log log = LogFactory.getLog(StudentServiceImpl.class);

    public Long insert(Student student) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + student));
        if (student == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        student.setCreateAt(Long.valueOf(currentTimeMillis));
        student.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)student);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + student));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Student> insertList(List<Student> studentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (studentList == null ? "null" : Integer.valueOf(studentList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(studentList)) {
            return new ArrayList<Student>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Student student : studentList) {
            student.setCreateAt(Long.valueOf(currentTimeMillis));
            student.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(studentList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + studentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public Long getUserIdByMobile(String mobile) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by mobile  : " + mobile));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserIdByMobile", new Object[]{mobile});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by mobile  : " + mobile));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Student.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Student student) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (student == null ? "null" : student.getId())));
        boolean result = false;
        if (student == null) {
            return true;
        }
        student.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)student);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + student));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + student));
        }
        return result;
    }

    public boolean updateList(List<Student> studentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (studentList == null ? "null" : Integer.valueOf(studentList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(studentList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Student student : studentList) {
            student.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(studentList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + studentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + studentList.size()));
        return result;
    }

    public Student getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Student student = null;
        if (id == null) {
            return student;
        }
        try {
            student = (Student)this.dao.get(Student.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return student;
    }

    public Student getObjectByPhone(String phone) throws ServiceException, ServiceDaoException {
        log.info((Object)("get data :" + phone));
        Student student = null;
        if (phone == null) {
            return student;
        }
        try {
            student = (Student)this.dao.getMapping("getObjectByPhone", new Object[]{phone});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by phone  : " + phone));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return student;
    }

    public List<Student> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List student = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Student>();
        }
        try {
            student = this.dao.getList(Student.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (student == null ? "null" : Integer.valueOf(student.size()))));
        return student;
    }

    public List<Long> getStudentIdsByJoinStatusOrderByCreateAt(Integer joinStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by joinStatus,start,limit  : " + joinStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStudentIdsByJoinStatusOrderByCreateAt", new Object[]{joinStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by joinStatus,start,limit)  : " + joinStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStudentIdsByClassIdOrderByCreateAt(Long classId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by classId,start,limit  : " + classId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStudentIdsByClassIdOrderByCreateAt", new Object[]{classId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by classId,start,limit)  : " + classId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStudentIdsByStudyNumOrderByCreateAt(Integer studyNum, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by studyNum,start,limit  : " + studyNum + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStudentIdsByStudyNumOrderByCreateAt", new Object[]{studyNum}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by studyNum,start,limit)  : " + studyNum + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStudentIdsByCourseOrderByCreateAt(Integer course, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by course,start,limit  : " + course + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStudentIdsByCourseOrderByCreateAt", new Object[]{course}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by course,start,limit)  : " + course + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStudentIdsByStudyStatusOrderByCreateAt(Integer studyStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by studyStatus,start,limit  : " + studyStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStudentIdsByStudyStatusOrderByCreateAt", new Object[]{studyStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by studyStatus,start,limit)  : " + studyStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStudentIdsByJoinStatusOrderByCreateAt(Integer joinStatus) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by joinStatus  : " + joinStatus));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStudentIdsByJoinStatusOrderByCreateAt", new Object[]{joinStatus});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by joinStatus)  : " + joinStatus));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStudentIdsByClassIdOrderByCreateAt(Long classId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by classId  : " + classId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStudentIdsByClassIdOrderByCreateAt", new Object[]{classId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by classId)  : " + classId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStudentIdsByStudyNumOrderByCreateAt(Integer studyNum) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by studyNum  : " + studyNum));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStudentIdsByStudyNumOrderByCreateAt", new Object[]{studyNum});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by studyNum)  : " + studyNum));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStudentIdsByCourseOrderByCreateAt(Integer course) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by course  : " + course));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStudentIdsByCourseOrderByCreateAt", new Object[]{course});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by course)  : " + course));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStudentIdsByStudyStatusOrderByCreateAt(Integer studyStatus) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by studyStatus  : " + studyStatus));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStudentIdsByStudyStatusOrderByCreateAt", new Object[]{studyStatus});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by studyStatus)  : " + studyStatus));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getStudentIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStudentIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStudentIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStudentIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStudentIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getStudentIdByOpenID(String openID) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by openID  : " + openID));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getStudentIdByOpenID", new Object[]{openID});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by openID  : " + openID));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }
}

