/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Review;
import com.ptteng.codinglord.common.service.ReviewService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReviewServiceImpl
extends BaseDaoServiceImpl
implements ReviewService {
    private static final Log log = LogFactory.getLog(ReviewServiceImpl.class);

    public Long insert(Review review) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + review));
        if (review == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        review.setCreateAt(Long.valueOf(currentTimeMillis));
        review.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)review);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + review));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Review> insertList(List<Review> reviewList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (reviewList == null ? "null" : Integer.valueOf(reviewList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(reviewList)) {
            return new ArrayList<Review>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Review review : reviewList) {
            review.setCreateAt(Long.valueOf(currentTimeMillis));
            review.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(reviewList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + reviewList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Review.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Review review) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (review == null ? "null" : review.getId())));
        boolean result = false;
        if (review == null) {
            return true;
        }
        review.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)review);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + review));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + review));
        }
        return result;
    }

    public boolean updateList(List<Review> reviewList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (reviewList == null ? "null" : Integer.valueOf(reviewList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(reviewList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Review review : reviewList) {
            review.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(reviewList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + reviewList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + reviewList.size()));
        return result;
    }

    public Review getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Review review = null;
        if (id == null) {
            return review;
        }
        try {
            review = (Review)this.dao.get(Review.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return review;
    }

    public List<Review> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List review = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Review>();
        }
        try {
            review = this.dao.getList(Review.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (review == null ? "null" : Integer.valueOf(review.size()))));
        return review;
    }

    public List<Long> getReviewIdsByClassIdOrderByCreateAt(Long classId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by classId,start,limit  : " + classId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getReviewIdsByClassIdOrderByCreateAt", new Object[]{classId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by classId,start,limit)  : " + classId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getReviewIdsByCourseOrderByCreateAt(Integer course, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by course,start,limit  : " + course + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getReviewIdsByCourseOrderByCreateAt", new Object[]{course}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by course,start,limit)  : " + course + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countReviewIdsByClassIdOrderByCreateAt(Long classId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by classId  : " + classId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getReviewIdsByClassIdOrderByCreateAt", new Object[]{classId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by classId)  : " + classId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countReviewIdsByCourseOrderByCreateAt(Integer course) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by course  : " + course));
        }
        Integer count = null;
        try {
            count = this.dao.count("getReviewIdsByCourseOrderByCreateAt", new Object[]{course});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by course)  : " + course));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countReviewIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getReviewIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getReviewIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

