/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Production;
import com.ptteng.codinglord.common.service.ProductionService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProductionServiceImpl
extends BaseDaoServiceImpl
implements ProductionService {
    private static final Log log = LogFactory.getLog(ProductionServiceImpl.class);

    public List<Long> getObjectBySid(Long sid, Integer start, Integer limit) throws ServiceDaoException, ServiceException {
        log.info((Object)(" get data : " + sid));
        ArrayList<Long> productionId = new ArrayList();
        try {
            productionId = this.dao.getIdList("getObjectBySid", new Object[]{sid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + productionId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return productionId;
    }

    public Long insert(Production production) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + production));
        if (production == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        production.setCreateAt(Long.valueOf(currentTimeMillis));
        production.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)production);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + production));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Production> insertList(List<Production> productionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (productionList == null ? "null" : Integer.valueOf(productionList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(productionList)) {
            return new ArrayList<Production>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Production production : productionList) {
            production.setCreateAt(Long.valueOf(currentTimeMillis));
            production.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(productionList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + productionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Production.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Production production) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (production == null ? "null" : production.getId())));
        boolean result = false;
        if (production == null) {
            return true;
        }
        production.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)production);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + production));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + production));
        }
        return result;
    }

    public boolean updateList(List<Production> productionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (productionList == null ? "null" : Integer.valueOf(productionList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(productionList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Production production : productionList) {
            production.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(productionList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + productionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + productionList.size()));
        return result;
    }

    public Production getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Production production = null;
        if (id == null) {
            return production;
        }
        try {
            production = (Production)this.dao.get(Production.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return production;
    }

    public List<Production> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List production = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Production>();
        }
        try {
            production = this.dao.getList(Production.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (production == null ? "null" : Integer.valueOf(production.size()))));
        return production;
    }

    public List<Long> getProductionIdsByStatusOrderByCreateAt(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductionIdsByStatusOrderByCreateAt", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProductionIdsBySidOrderByCreateAt(Long sid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by sid,start,limit  : " + sid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductionIdsBySidOrderByCreateAt", new Object[]{sid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by sid,start,limit)  : " + sid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProductionIdsByCourseOrderByCreateAt(Integer course, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by course,start,limit  : " + course + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductionIdsByCourseOrderByCreateAt", new Object[]{course}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by course,start,limit)  : " + course + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProductionIdsByStatusOrderByCreateAt(Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status  : " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProductionIdsByStatusOrderByCreateAt", new Object[]{status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status)  : " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countProductionIdsBySidOrderByCreateAt(Long sid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by sid  : " + sid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProductionIdsBySidOrderByCreateAt", new Object[]{sid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by sid)  : " + sid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countProductionIdsByCourseOrderByCreateAt(Integer course) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by course  : " + course));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProductionIdsByCourseOrderByCreateAt", new Object[]{course});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by course)  : " + course));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getProductionIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductionIdsByPutaway", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProductionIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProductionIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProductionIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

