/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Preview;
import com.ptteng.codinglord.common.service.PreviewService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreviewServiceImpl
extends BaseDaoServiceImpl
implements PreviewService {
    private static final Log log = LogFactory.getLog(PreviewServiceImpl.class);

    public List<Long> getIdByClassId(Long classId) throws ServiceException, ServiceDaoException {
        log.info((Object)("select classId is :" + classId));
        ArrayList<Long> ids = new ArrayList();
        try {
            ids = this.dao.getIdList("getPreviewByClassId", new Object[]{classId}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return ids;
    }

    public Long insert(Preview preview) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + preview));
        if (preview == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        preview.setCreateAt(Long.valueOf(currentTimeMillis));
        preview.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)preview);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + preview));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Preview> insertList(List<Preview> previewList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (previewList == null ? "null" : Integer.valueOf(previewList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(previewList)) {
            return new ArrayList<Preview>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Preview preview : previewList) {
            preview.setCreateAt(Long.valueOf(currentTimeMillis));
            preview.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(previewList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + previewList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Preview.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Preview preview) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (preview == null ? "null" : preview.getId())));
        boolean result = false;
        if (preview == null) {
            return true;
        }
        preview.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)preview);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + preview));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + preview));
        }
        return result;
    }

    public boolean updateList(List<Preview> previewList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (previewList == null ? "null" : Integer.valueOf(previewList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(previewList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Preview preview : previewList) {
            preview.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(previewList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + previewList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + previewList.size()));
        return result;
    }

    public Preview getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Preview preview = null;
        if (id == null) {
            return preview;
        }
        try {
            preview = (Preview)this.dao.get(Preview.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return preview;
    }

    public List<Preview> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List preview = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Preview>();
        }
        try {
            preview = this.dao.getList(Preview.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (preview == null ? "null" : Integer.valueOf(preview.size()))));
        return preview;
    }

    public List<Long> getPreviewIdsByCourseOrderByCreateAt(Integer course, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by course,start,limit  : " + course + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPreviewIdsByCourseOrderByCreateAt", new Object[]{course}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by course,start,limit)  : " + course + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getPreviewIdsByClassIdOrderByCreateAt(Long classId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by classId,start,limit  : " + classId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPreviewIdsByClassIdOrderByCreateAt", new Object[]{classId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by classId,start,limit)  : " + classId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPreviewIdsByCourseOrderByCreateAt(Integer course) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by course  : " + course));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPreviewIdsByCourseOrderByCreateAt", new Object[]{course});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by course)  : " + course));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countPreviewIdsByClassIdOrderByCreateAt(Long classId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by classId  : " + classId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPreviewIdsByClassIdOrderByCreateAt", new Object[]{classId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by classId)  : " + classId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getPreviewIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPreviewIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPreviewIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPreviewIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPreviewIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

