/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Period;
import com.ptteng.codinglord.common.service.PeriodService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PeriodServiceImpl
extends BaseDaoServiceImpl
implements PeriodService {
    private static final Log log = LogFactory.getLog(PeriodServiceImpl.class);

    public Long insert(Period period) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + period));
        if (period == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        period.setCreateAt(Long.valueOf(currentTimeMillis));
        period.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)period);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + period));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Period> insertList(List<Period> periodList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (periodList == null ? "null" : Integer.valueOf(periodList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(periodList)) {
            return new ArrayList<Period>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Period period : periodList) {
            period.setCreateAt(Long.valueOf(currentTimeMillis));
            period.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(periodList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + periodList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Period.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Period period) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (period == null ? "null" : period.getId())));
        boolean result = false;
        if (period == null) {
            return true;
        }
        period.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)period);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + period));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + period));
        }
        return result;
    }

    public boolean updateList(List<Period> periodList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (periodList == null ? "null" : Integer.valueOf(periodList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(periodList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Period period : periodList) {
            period.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(periodList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + periodList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + periodList.size()));
        return result;
    }

    public Period getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Period period = null;
        if (id == null) {
            return period;
        }
        try {
            period = (Period)this.dao.get(Period.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return period;
    }

    public List<Period> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List period = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Period>();
        }
        try {
            period = this.dao.getList(Period.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (period == null ? "null" : Integer.valueOf(period.size()))));
        return period;
    }

    public List<Long> getPeriodIdsByChapterIdOrderByCreateAt(Long chapterId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by chapterId,start,limit  : " + chapterId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPeriodIdsByChapterIdOrderByCreateAt", new Object[]{chapterId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by chapterId,start,limit)  : " + chapterId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getPeriodIdsByStatusAndChapterIdOrderByCreateAt(Integer status, Long chapterId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,chapterId,start,limit  : " + status + " , " + chapterId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPeriodIdsByStatusAndChapterIdOrderByCreateAt", new Object[]{status, chapterId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,chapterId,start,limit)  : " + status + " , " + chapterId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPeriodIdsByChapterIdOrderByCreateAt(Long chapterId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by chapterId  : " + chapterId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPeriodIdsByChapterIdOrderByCreateAt", new Object[]{chapterId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by chapterId)  : " + chapterId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countPeriodIdsByStatusAndChapterIdOrderByCreateAt(Integer status, Long chapterId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status,chapterId  : " + status + " , " + chapterId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPeriodIdsByStatusAndChapterIdOrderByCreateAt", new Object[]{status, chapterId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status,chapterId)  : " + status + " , " + chapterId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getPeriodIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPeriodIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPeriodIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPeriodIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPeriodIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

