/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Classes;
import com.ptteng.codinglord.common.service.ClassesService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassesServiceImpl
extends BaseDaoServiceImpl
implements ClassesService {
    private static final Log log = LogFactory.getLog(ClassesServiceImpl.class);

    public Long insert(Classes classesEntity) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + classesEntity));
        if (classesEntity == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        classesEntity.setCreateAt(Long.valueOf(currentTimeMillis));
        classesEntity.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)classesEntity);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + classesEntity));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Classes> insertList(List<Classes> classesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (classesList == null ? "null" : Integer.valueOf(classesList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(classesList)) {
            return new ArrayList<Classes>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Classes classesEntity : classesList) {
            classesEntity.setCreateAt(Long.valueOf(currentTimeMillis));
            classesEntity.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(classesList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + classesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Classes.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Classes classesEntity) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (classesEntity == null ? "null" : classesEntity.getId())));
        boolean result = false;
        if (classesEntity == null) {
            return true;
        }
        classesEntity.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)classesEntity);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + classesEntity));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + classesEntity));
        }
        return result;
    }

    public boolean updateList(List<Classes> classesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (classesList == null ? "null" : Integer.valueOf(classesList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(classesList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Classes classesEntity : classesList) {
            classesEntity.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(classesList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + classesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + classesList.size()));
        return result;
    }

    public Classes getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Classes classesEntity = null;
        if (id == null) {
            return classesEntity;
        }
        try {
            classesEntity = (Classes)this.dao.get(Classes.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return classesEntity;
    }

    public List<Classes> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List classesEntity = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Classes>();
        }
        try {
            classesEntity = this.dao.getList(Classes.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (classesEntity == null ? "null" : Integer.valueOf(classesEntity.size()))));
        return classesEntity;
    }

    public List<Long> getClassesIdsByClassNumOrderByCreateAt(Integer classNum, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by classNum,start,limit  : " + classNum + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassesIdsByClassNumOrderByCreateAt", new Object[]{classNum}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by classesNum,start,limit)  : " + classNum + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countClassesIdsByClassNumOrderByCreateAt(Integer classNum) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by classNum  : " + classNum));
        }
        Integer count = null;
        try {
            count = this.dao.count("getClassesIdsByClassNumOrderByCreateAt", new Object[]{classNum});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by classNum)  : " + classNum));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getClassesIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassesIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countClassesIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getClassesIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getClassIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

