/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Chapter;
import com.ptteng.codinglord.common.service.ChapterService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChapterServiceImpl
extends BaseDaoServiceImpl
implements ChapterService {
    private static final Log log = LogFactory.getLog(ChapterServiceImpl.class);

    public Long insert(Chapter chapter) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + chapter));
        if (chapter == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        chapter.setCreateAt(Long.valueOf(currentTimeMillis));
        chapter.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)chapter);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + chapter));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Chapter> insertList(List<Chapter> chapterList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (chapterList == null ? "null" : Integer.valueOf(chapterList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(chapterList)) {
            return new ArrayList<Chapter>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Chapter chapter : chapterList) {
            chapter.setCreateAt(Long.valueOf(currentTimeMillis));
            chapter.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(chapterList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + chapterList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Chapter.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Chapter chapter) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (chapter == null ? "null" : chapter.getId())));
        boolean result = false;
        if (chapter == null) {
            return true;
        }
        chapter.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)chapter);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + chapter));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + chapter));
        }
        return result;
    }

    public boolean updateList(List<Chapter> chapterList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (chapterList == null ? "null" : Integer.valueOf(chapterList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(chapterList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Chapter chapter : chapterList) {
            chapter.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(chapterList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + chapterList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + chapterList.size()));
        return result;
    }

    public Chapter getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Chapter chapter = null;
        if (id == null) {
            return chapter;
        }
        try {
            chapter = (Chapter)this.dao.get(Chapter.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return chapter;
    }

    public List<Chapter> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List chapter = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Chapter>();
        }
        try {
            chapter = this.dao.getList(Chapter.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (chapter == null ? "null" : Integer.valueOf(chapter.size()))));
        return chapter;
    }

    public List<Long> getChapterIdsByStatusAndCourseIdOrderByCreateAt(Integer status, Long courseId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,courseId,start,limit  : " + status + " , " + courseId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getChapterIdsByStatusAndCourseIdOrderByCreateAt", new Object[]{status, courseId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,courseId,start,limit)  : " + status + " , " + courseId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getChapterIdsByCourseIdOrderByCreateAt(Long courseId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by courseId,start,limit  : " + courseId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getChapterIdsByCourseIdOrderByCreateAt", new Object[]{courseId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by courseId,start,limit)  : " + courseId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countChapterIdsByStatusAndCourseIdOrderByCreateAt(Integer status, Long courseId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status,courseId  : " + status + " , " + courseId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getChapterIdsByStatusAndCourseIdOrderByCreateAt", new Object[]{status, courseId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status,courseId)  : " + status + " , " + courseId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countChapterIdsByCourseIdOrderByCreateAt(Long courseId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by courseId  : " + courseId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getChapterIdsByCourseIdOrderByCreateAt", new Object[]{courseId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by courseId)  : " + courseId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getChapterIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getChapterIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countChapterIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getChapterIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getChapterIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

