/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.CardSpecies;
import com.ptteng.codinglord.common.service.CardSpeciesService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CardSpeciesServiceImpl
extends BaseDaoServiceImpl
implements CardSpeciesService {
    private static final Log log = LogFactory.getLog(CardSpeciesServiceImpl.class);

    public Long insert(CardSpecies cardSpecies) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + cardSpecies));
        if (cardSpecies == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        cardSpecies.setCreateAt(Long.valueOf(currentTimeMillis));
        cardSpecies.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)cardSpecies);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + cardSpecies));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<CardSpecies> insertList(List<CardSpecies> cardSpeciesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (cardSpeciesList == null ? "null" : Integer.valueOf(cardSpeciesList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(cardSpeciesList)) {
            return new ArrayList<CardSpecies>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (CardSpecies cardSpecies : cardSpeciesList) {
            cardSpecies.setCreateAt(Long.valueOf(currentTimeMillis));
            cardSpecies.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(cardSpeciesList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + cardSpeciesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(CardSpecies.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(CardSpecies cardSpecies) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (cardSpecies == null ? "null" : cardSpecies.getId())));
        boolean result = false;
        if (cardSpecies == null) {
            return true;
        }
        cardSpecies.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)cardSpecies);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + cardSpecies));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + cardSpecies));
        }
        return result;
    }

    public boolean updateList(List<CardSpecies> cardSpeciesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (cardSpeciesList == null ? "null" : Integer.valueOf(cardSpeciesList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(cardSpeciesList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (CardSpecies cardSpecies : cardSpeciesList) {
            cardSpecies.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(cardSpeciesList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + cardSpeciesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + cardSpeciesList.size()));
        return result;
    }

    public CardSpecies getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        CardSpecies cardSpecies = null;
        if (id == null) {
            return cardSpecies;
        }
        try {
            cardSpecies = (CardSpecies)this.dao.get(CardSpecies.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return cardSpecies;
    }

    public List<CardSpecies> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List cardSpecies = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<CardSpecies>();
        }
        try {
            cardSpecies = this.dao.getList(CardSpecies.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (cardSpecies == null ? "null" : Integer.valueOf(cardSpecies.size()))));
        return cardSpecies;
    }

    public List<Long> getCardSpeciesIdsByStatusOrderByCreateAt(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCardSpeciesIdsByStatusOrderByCreateAt", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCardSpeciesIdsByStatusOrderByCreateAt(Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status  : " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCardSpeciesIdsByStatusOrderByCreateAt", new Object[]{status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status)  : " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCardSpeciesIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCardSpeciesIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCardSpeciesIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCardSpeciesIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCardSpeciesIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

