/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.bean.yl;

import com.gemantic.common.util.MyTimeUtil;
import com.qding.common.util.DataUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class QueryBean {
    private String sendSeqId;
    private String transType;
    private String merchantId;
    private String merchantOrderId;
    private String merchantOrderTime;
    private String msgExt;
    private String misc;

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public String getMerchantOrderTime() {
        return this.merchantOrderTime;
    }

    public void setMerchantOrderTime(String merchantOrderTime) {
        this.merchantOrderTime = merchantOrderTime;
    }

    public static void main(String[] args) {
        QueryBean req = new QueryBean();
        System.out.println(req.doc2String(req.toDocument()));
    }

    public Document toDocument() {
        Document doc = new Document();
        Element root = new Element("upbp");
        root.setAttribute("application", "MTransInfo.Req");
        root.setAttribute("version", "1.0.0");
        root.setAttribute("sendTime", QueryBean.formatDate(new Date()));
        this.sendSeqId = MyTimeUtil.getTimeInyyyyMMdd() + DataUtils.getRandomIntString((int)4);
        root.setAttribute("sendSeqId", this.sendSeqId);
        this.createElement(root, "transType", this.transType);
        this.createElement(root, "merchantId", this.merchantId);
        this.createElement(root, "merchantOrderId", this.merchantOrderId);
        this.createElement(root, "merchantOrderTime", this.merchantOrderTime);
        doc.setRootElement(root);
        return doc;
    }

    private Element createElement(Element parent, String name, String value) {
        Element elem = new Element(name);
        elem.setText(value);
        parent.getChildren().add(elem);
        return elem;
    }

    public static String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        return formatter.format(date);
    }

    public String doc2String(Document doc) {
        try {
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            XMLOutputter xmlout = new XMLOutputter(format);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            xmlout.output(doc, (OutputStream)bo);
            return bo.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getTransType() {
        return this.transType;
    }

    public void setTransType(String transType) {
        this.transType = transType;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }
}

