/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.codinglord.common.bean.yl;

import com.ptteng.codinglord.common.bean.yl.QueryBean;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class CancelBean {
    private String sendSeqId;
    private String merchantName;
    private String merchantId;
    private String merchantOrderId;
    private String merchantOrderTime;
    private String merchantOrderAmt;
    private String merchantOrderCurrency = "156";
    private String cupsQid;
    private String backUrl;
    private String msgExt;
    private String misc;

    public static void main(String[] args) {
        QueryBean req = new QueryBean();
        System.out.println(req.doc2String(req.toDocument()));
    }

    public Document toDocument() {
        Document doc = new Document();
        Element root = new Element("updp");
        root.setAttribute("application", "MGw.Req");
        root.setAttribute("version", "1.0.0");
        root.setAttribute("sendTime", CancelBean.formatDate(new Date()));
        root.setAttribute("sendSeqId", this.sendSeqId);
        doc.setRootElement(root);
        this.createElement(root, "merchantName", this.merchantName);
        this.createElement(root, "merchantId", this.merchantId);
        this.createElement(root, "merchantOrderId", this.merchantOrderId);
        this.createElement(root, "merchantOrderTime", this.merchantOrderTime);
        this.createElement(root, "merchantOrderAmt", this.merchantOrderAmt);
        this.createElement(root, "merchantOrderCurrency", this.merchantOrderCurrency);
        this.createElement(root, "cupsQid", this.cupsQid);
        this.createElement(root, "backUrl", this.backUrl);
        this.createElement(root, "msgExt", this.msgExt);
        this.createElement(root, "misc", this.misc);
        return doc;
    }

    private Element createElement(Element parent, String name, String value) {
        Element elem = new Element(name);
        elem.setText(value);
        parent.getChildren().add(elem);
        return elem;
    }

    public static String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        return formatter.format(date);
    }

    public String doc2String(Document doc) {
        try {
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            XMLOutputter xmlout = new XMLOutputter(format);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            xmlout.output(doc, (OutputStream)bo);
            return bo.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

