-- ----------------------------
-- Table structure for `production`
-- ----------------------------
-- DROP TABLE IF EXISTS `production`;
CREATE TABLE `production` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增长ID',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '作品名称',
  `sid` bigint(20) NOT NULL DEFAULT '0' COMMENT '学生id（即作者id）',
  `course` int(11) NOT NULL DEFAULT '0' COMMENT '课程的键',
  `teacher_name` varchar(20) NOT NULL DEFAULT '' COMMENT '老师姓名',
  `cover_url` varchar(500) NOT NULL DEFAULT '',
  `video_url` varchar(500) NOT NULL DEFAULT '',
  `introduce` varchar(350) NOT NULL DEFAULT '',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '上下架状态  1：下架 2：上架',
  `comment` varchar(350) NOT NULL DEFAULT '',
  `create_by` bigint(20) NOT NULL DEFAULT '0' COMMENT '创建人ID',
  `update_by` bigint(20) NOT NULL DEFAULT '0' COMMENT '更新人ID',
  `update_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '数据更新时间',
  `create_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '数据创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `student`
-- ----------------------------
-- DROP TABLE IF EXISTS `student`;
CREATE TABLE `student` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增长ID',
  `openid` varchar(50) NOT NULL DEFAULT '' COMMENT '微信openid',
  `parent_name` varchar(10) NOT NULL DEFAULT '' COMMENT '家长姓名',
  `teacher_name` varchar(10) NOT NULL DEFAULT '' COMMENT '老师姓名',
  `name` varchar(10) NOT NULL DEFAULT '' COMMENT '姓名（或微信昵称）',
  `head_img` varchar(500) NOT NULL DEFAULT '' COMMENT '头像（或微信头像）',
  `birthday` bigint(20) NOT NULL DEFAULT '0' COMMENT '生日',
  `sex` tinyint(4) NOT NULL DEFAULT '0' COMMENT '性别 1：男  2：女',
  `phone` varchar(15) NOT NULL DEFAULT '' COMMENT '电话',
  `join_status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '报名状态 1：未报名线下  2：已报名线下',
  `study_status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '学习状态 1：在学  2：退学  3：毕业  4：未学',
  `study_num` int(11) NOT NULL DEFAULT '0' COMMENT '学号',
  `course` int(11) NOT NULL DEFAULT '0' COMMENT '课程',
  `class_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '班级ID',
  `entrance_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '入学时间',
  `graduate_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '毕业时间',
  `create_by` bigint(20) NOT NULL DEFAULT '0' COMMENT '创建人ID',
  `update_by` bigint(20) NOT NULL DEFAULT '0' COMMENT '更新人ID',
  `update_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '数据更新时间',
  `create_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '数据创建时间（即用户注册时间）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `class`
-- ----------------------------
-- DROP TABLE IF EXISTS `class`;
CREATE TABLE `classes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增长ID',
  `class_num` int(11) NOT NULL DEFAULT '0' COMMENT '班号',
  `course` int(11) NOT NULL DEFAULT '0' COMMENT '课程',
  `current_count` int(11) NOT NULL DEFAULT '0' COMMENT '班级当前人数',
  `limit_count` int(11) NOT NULL DEFAULT '10' COMMENT '班级人数上限',
  `create_by` bigint(20) NOT NULL DEFAULT '0' COMMENT '创建人ID',
  `update_by` bigint(20) NOT NULL DEFAULT '0' COMMENT '更新人ID',
  `update_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '数据更新时间',
  `create_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '数据创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `preview`
-- ----------------------------
-- DROP TABLE IF EXISTS `preview`;
CREATE TABLE `preview` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增长ID',
  `section` varchar(50) NOT NULL DEFAULT '' COMMENT '课程章节',
  `time` bigint(20) NOT NULL DEFAULT '0' COMMENT '上课时间',
  `place` varchar(50) NOT NULL DEFAULT '' COMMENT '上课地点',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `content` varchar(350) NOT NULL DEFAULT '' COMMENT '内容',
  `ability` varchar(250) NOT NULL DEFAULT '' COMMENT '培养能力',
  `remark` varchar(150) NOT NULL DEFAULT '' COMMENT '备注',
  `course` int(11) NOT NULL DEFAULT '0' COMMENT '课程',
  `class_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '班级ID',
  `create_by` bigint(20) NOT NULL DEFAULT '0' COMMENT '创建人ID',
  `update_by` bigint(20) NOT NULL DEFAULT '0' COMMENT '更新人ID',
  `update_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '数据更新时间',
  `create_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '数据创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `review`
-- ----------------------------
-- DROP TABLE IF EXISTS `review`;
CREATE TABLE `review` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增长ID',
  `section` varchar(50) NOT NULL DEFAULT '' COMMENT '章节',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `teacher_name` varchar(10) NOT NULL DEFAULT '' COMMENT '老师姓名',
  `cover_url` varchar(500) NOT NULL DEFAULT '' COMMENT '封面url',
  `video_url` varchar(500) NOT NULL DEFAULT '' COMMENT '视频url',
  `introduce` varchar(350) NOT NULL DEFAULT '' COMMENT '简介',
  `knowledge` varchar(250) NOT NULL DEFAULT '' COMMENT '知识点',
  `course` int(11) NOT NULL DEFAULT '0' COMMENT '课程',
  `class_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '班级ID',
  `create_by` bigint(20) NOT NULL DEFAULT '0' COMMENT '创建人ID',
  `update_by` bigint(20) NOT NULL DEFAULT '0' COMMENT '更新人ID',
  `update_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '数据更新时间',
  `create_at` bigint(20) NOT NULL DEFAULT '0' COMMENT '数据创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8;




/*三期*/
-- ----------------------------
-- Table structure for `school`
-- ----------------------------
-- DROP TABLE IF EXISTS `school`;
CREATE TABLE `school` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(20) NOT NULL   COMMENT '名称',
    `mobile` varchar(20) NOT NULL   COMMENT '联系电话',
    `teach_time` varchar(100) NOT NULL   COMMENT '上课时间',
    `introduce_list` text NOT NULL COMMENT '校园介绍json格式数据',
    `pic_list` text NOT NULL COMMENT '校园照片json格式数据',
    `province` varchar(15) NOT NULL   COMMENT '地址-省',
    `city` varchar(15) NOT NULL   COMMENT '地址-市',
    `district` varchar(15) NOT NULL   COMMENT '地址-区',
    `address` varchar(30) NOT NULL   COMMENT '详细地址',
    `status` tinyint(4) NOT NULL   COMMENT '上下架状态（1下架   2上架）',
    `charger_name` varchar(15) NOT NULL   COMMENT '负责人姓名',
    `charger_mobile` varchar(15) NOT NULL   COMMENT '负责人电话',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `course`
-- ----------------------------
-- DROP TABLE IF EXISTS `course`;
CREATE TABLE `course` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `subject_id` bigint NOT NULL   COMMENT '科目id',
    `type` tinyint(4) NOT NULL   COMMENT '课程类型  1-精品课  2-公开课',
    `price` varchar(30) NOT NULL   COMMENT '价格',
    `status` tinyint(4) NOT NULL   COMMENT '上下架状态 1下架  2上架',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `chapter`
-- ----------------------------
-- DROP TABLE IF EXISTS `chapter`;
CREATE TABLE `chapter` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `subject_id` bigint NOT NULL   COMMENT '科目id',
    `course_id` bigint NOT NULL   COMMENT '所属课程id',
    `name` varchar(15) NOT NULL   COMMENT '章节名称',
    `cover` varchar(500) NOT NULL   COMMENT '章节封面url',
    `status` tinyint(4) NOT NULL   COMMENT '上下架状态 1下架  2上架',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `period`
-- ----------------------------
-- DROP TABLE IF EXISTS `period`;
CREATE TABLE `period` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `subject_id` bigint NOT NULL   COMMENT '科目id',
    `course_id` bigint NOT NULL   COMMENT '所属课程id',
    `chapter_id` bigint NOT NULL   COMMENT '所属章节id',
    `name` varchar(15) NOT NULL   COMMENT '课时名称',
    `video_cover` varchar(500) NOT NULL   COMMENT '视频封面',
    `teacher_photo` varchar(500) NOT NULL   COMMENT '老师头像',
    `teacher_name` varchar(10) NOT NULL   COMMENT '老师姓名',
    `video_url` varchar(500) NOT NULL   COMMENT '视频链接',
    `introduce` varchar(220) NOT NULL   COMMENT '课时介绍',
    `status` tinyint(4) NOT NULL   COMMENT '上下架状态 1下架  2上架',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `card_species`
-- ----------------------------
-- DROP TABLE IF EXISTS `card_species`;
CREATE TABLE `card_species` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name`  varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '卡券种类名称',
    `type` tinyint(4) NOT NULL   COMMENT '卡券类型   10-报名券  20-报名获取的购课券  21-消费获取的购课券',
    `price` decimal(10,0) NOT NULL COMMENT '卡券金额' ,
    `useful_day` int NOT NULL   COMMENT '有效期（天）',
    `conditions` varchar(120) NOT NULL   COMMENT '使用条件',
    `pic` varchar(500) NOT NULL   COMMENT '图片',
    `enable` tinyInt(4) NOT NULL   COMMENT '启用状态   1-已启用   2-已禁用',
    `status` tinyint(4) NOT NULL   COMMENT '上下架状态 1下架  2上架',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    `is_delete`  tinyint(4) NOT NULL COMMENT '是否删除   0-未删除  1-已删除',
    `money_lower_limit`  decimal(20,0) NULL DEFAULT 0 COMMENT '获取购课券的下限消费金额',
    `money_upper_limit`  decimal(20,0) NULL DEFAULT 0 COMMENT '获取购课券的上限消费金额',
    `creater_name`  varchar(30) NULL COMMENT '创建人姓名',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `card`
-- ----------------------------
-- DROP TABLE IF EXISTS `card`;
CREATE TABLE `card` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `species_id` bigint NOT NULL   COMMENT '卡券种类id',
    `type` tinyint(4) NOT NULL   COMMENT '卡券类型   10-报名券  20-报名获取的购课券  21-消费获取的购课券',
    `num` varchar(25) NOT NULL   COMMENT '卡券编号',
    `card_status` tinyint(4) NOT NULL   COMMENT '卡券状态  1-未使用  2-已使用  3-已过期',
    `student_id` bigint NOT NULL   COMMENT '持有人id',
    `useful_day` int NOT NULL   COMMENT '有效期',
    `end_at` bigint NOT NULL   COMMENT '到期时间',
    `price`  decimal(10,0) NOT NULL COMMENT '金额',
    `source` tinyint(4) NOT NULL   COMMENT '来源 1-分享获得  2-消费获得',
    `from_student_id` bigint NOT NULL   COMMENT '来源id（通过邀请获得的购课券，邀请人id）',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `production_student_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `production_student_relation`;
CREATE TABLE `production_student_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `student_id` bigint NOT NULL   COMMENT '学生id',
    `production_id` bigint NOT NULL   COMMENT '作品id',
    `relation_type` tinyint(4) NOT NULL   COMMENT '关联类型  1-点赞   2-购买',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `course_student_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `course_student_relation`;
CREATE TABLE `course_student_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `student_id` bigint NOT NULL   COMMENT '学生id',
    `course_id` bigint NOT NULL   COMMENT '线上精品课id',
    `relation_type` tinyint(4) NOT NULL   COMMENT '关联类型  1-点赞   2-购买',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `subject`
-- ----------------------------
-- DROP TABLE IF EXISTS `subject`;
CREATE TABLE `subject` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(15) NOT NULL   COMMENT '课程名称',
    `list_pic` varchar(500) NOT NULL   COMMENT '列表页展示的封面url',
    `detail_pic` varchar(500) NOT NULL   COMMENT '详情页展示的封面url',
    `brief` varchar(250) NOT NULL   COMMENT '课程简介',
    `target` varchar(120) NOT NULL   COMMENT '学习目标',
    `status`  tinyint(4) NOT NULL COMMENT '上下架状态  1-下架  2-上架',
    `age`  varchar(30) NOT NULL COMMENT '适合年龄段',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `school_subject_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `school_subject_relation`;
CREATE TABLE `school_subject_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `school_id` bigint NOT NULL   COMMENT '校园id',
    `subject_id` bigint NOT NULL   COMMENT '课程id',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;












