package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Version;
import com.ptteng.codinglord.common.service.VersionService;
import com.ptteng.codinglord.common.model.Version;
import com.ptteng.codinglord.common.service.VersionService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class VersionServiceImpl extends BaseDaoServiceImpl implements VersionService {

 

	private static final Log log = LogFactory.getLog(VersionServiceImpl.class);



		   
		@Override
		public Long insert(Version version)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + version);

		if (version == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		version.setCreateAt(currentTimeMillis);
		version.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(version);
		} catch (DaoException e) {
			log.error(" insert wrong : " + version);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Version> insertList(List<Version> versionList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (versionList == null ? "null" : versionList.size()));
      
		List<Version> resultList = null;

		if (CollectionUtils.isEmpty(versionList)) {
			return new ArrayList<Version>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Version version : versionList) {
			version.setCreateAt(currentTimeMillis);
			version.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Version>) dao.batchSave(versionList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + versionList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Version.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Version version)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (version == null ? "null" : version.getId()));

		boolean result = false;

		if (version == null) {
			return true;
		}

		version.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(version);
		} catch (DaoException e) {
			log.error(" update wrong : " + version);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + version);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Version> versionList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (versionList == null ? "null" : versionList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(versionList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Version version : versionList) {
			version.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(versionList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + versionList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + versionList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Version getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Version version = null;

		if (id == null) {
			return version;
		}

		try {
			version = (Version) dao.get(Version.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return version;		
		}	
		  
    	   
		@Override
		public List<Version> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Version> version = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Version>();
		}

		try {
			version = (List<Version>) dao.getList(Version.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (version == null ? "null" : version.size()));
    
		return version;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getVersionIdsByOsAndVersionCodeOrderByIsForceUpdate(String os,String versionCode,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by os,versionCode,start,limit  : " + os+" , "+versionCode+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getVersionIdsByOsAndVersionCodeOrderByIsForceUpdate", new Object[] { os,versionCode},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by os,versionCode,start,limit)  : " + os+" , "+versionCode+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getVersionIdsByOs(String os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by os,start,limit  : " + os+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getVersionIdsByOs", new Object[] {os},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by os,start,limit)  : " + os+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;

	}

	@Override
	public List<Long> getVersionIdsByOsOrderByVersionCode(String os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by os,start,limit  : " + os+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getVersionIdsByOsOrderByVersionCode", new Object[] {os},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by os,start,limit)  : " + os+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public Long getVersionIdByOsAndVersionCode(String os, String code) throws ServiceException, ServiceDaoException {
		if (log.isInfoEnabled()) {
			log.info(" get id by os  : " + os + " code : " + code);
		}
		Long id = null;

		// TODO 参数检查!

		try {

			id = (Long) dao.getMapping("getVersionIdByOsAndVersionCode", new Object[]{os, code});

		} catch (DaoException e) {
			log.error("  get id wrong by os  : " + os + " code : " + code);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get id success : " + id);
		}
		return id;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countVersionIdsByOsAndVersionCodeOrderByIsForceUpdate(String os,String versionCode)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by os,versionCode  : " + os+" , "+versionCode );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getVersionIdsByOsAndVersionCodeOrderByIsForceUpdate", new Object[] { os,versionCode});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by os,versionCode)  : " + os+" , "+versionCode );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getVersionIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getVersionIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countVersionIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getVersionIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getVersionIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

