package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Subject;
import com.ptteng.codinglord.common.service.SubjectService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class SubjectServiceImpl extends BaseDaoServiceImpl implements SubjectService {

 

	private static final Log log = LogFactory.getLog(SubjectServiceImpl.class);



		   
		@Override
		public Long insert(Subject subject)throws ServiceException, ServiceDaoException {
		
	
		          
    log.info(" insert data : " + subject);

		if (subject == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		subject.setCreateAt(currentTimeMillis);
		subject.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(subject);
		} catch (DaoException e) {
			log.error(" insert wrong : " + subject);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Subject> insertList(List<Subject> subjectList)throws ServiceException, ServiceDaoException {
		
	
		          	
        log.info(" insert lists : " + (subjectList == null ? "null" : subjectList.size()));
      
		List<Subject> resultList = null;

		if (CollectionUtils.isEmpty(subjectList)) {
			return new ArrayList<Subject>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Subject subject : subjectList) {
			subject.setCreateAt(currentTimeMillis);
			subject.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Subject>) dao.batchSave(subjectList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + subjectList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException {
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Subject.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Subject subject)throws ServiceException, ServiceDaoException {
		
	
		          
	log.info(" update data : " + (subject == null ? "null" : subject.getId()));

		boolean result = false;

		if (subject == null) {
			return true;
		}

		subject.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(subject);
		} catch (DaoException e) {
			log.error(" update wrong : " + subject);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + subject);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Subject> subjectList)throws ServiceException, ServiceDaoException {
		
	
		          log.info(" update lists : " + (subjectList == null ? "null" : subjectList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(subjectList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Subject subject : subjectList) {
			subject.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(subjectList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + subjectList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + subjectList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Subject getObjectById(Long id)throws ServiceException, ServiceDaoException {
		
	
		              
        log.info(" get data : " + id);
      
		Subject subject = null;

		if (id == null) {
			return subject;
		}

		try {
			subject = (Subject) dao.get(Subject.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return subject;		
		}	
		  
    	   
		@Override
		public List<Subject> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException {
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Subject> subject = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Subject>();
		}

		try {
			subject = (List<Subject>) dao.getList(Subject.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (subject == null ? "null" : subject.size()));
    
		return subject;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getSubjectIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getSubjectIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countSubjectIds() throws ServiceException,
                ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getSubjectIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getSubjectIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

