package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;

import com.ptteng.codinglord.common.model.Student;
import com.ptteng.codinglord.common.service.StudentService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class StudentServiceImpl extends BaseDaoServiceImpl implements StudentService {


    private static final Log log = LogFactory.getLog(StudentServiceImpl.class);


    @Override
    public Long insert(Student student) throws ServiceException, ServiceDaoException {

        log.info(" insert data : " + student);

        if (student == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        student.setCreateAt(currentTimeMillis);
        student.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(student);
        } catch (DaoException e) {
            log.error(" insert wrong : " + student);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }
//@Override
//    public Student getObjectsByOpneid(String openid)throws ServiceException, ServiceDaoException{
//    Student student = null;
//    try {
//        Map<String, Object> paramList = DynamicUtil
//        student = (Student) dao.get(Student.class, openid);
//    }catch (DaoException e) {
//        log.error(" get id wrong by openid  : " + openid);
//        log.error(e);
//        e.printStackTrace();
//        throw new ServiceDaoException(e);
//    }
//    return student;
//    }
    @Override
    public List<Student> insertList(List<Student> studentList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (studentList == null ? "null" : studentList.size()));

        List<Student> resultList = null;

        if (CollectionUtils.isEmpty(studentList)) {
            return new ArrayList<Student>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Student student : studentList) {
            student.setCreateAt(currentTimeMillis);
            student.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Student>) dao.batchSave(studentList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + studentList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }

    @Override
    public Long getUserIdByMobile(String mobile) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by mobile  : " + mobile);
        }
        Long id = null;

        // TODO 参数检查!

        try {
            id = (Long) dao.getMapping("getUserIdByMobile", new Object[]{mobile});
        } catch (DaoException e) {
            log.error(" get id wrong by mobile  : " + mobile);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Student.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Student student) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (student == null ? "null" : student.getId()));

        boolean result = false;

        if (student == null) {
            return true;
        }

        student.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(student);
        } catch (DaoException e) {
            log.error(" update wrong : " + student);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + student);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Student> studentList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (studentList == null ? "null" : studentList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(studentList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Student student : studentList) {
            student.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(studentList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + studentList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + studentList.size());

        return result;
    }


    @Override
    public Student getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Student student = null;

        if (id == null) {
            return student;
        }

        try {
            student = (Student) dao.get(Student.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return student;
    }

    @Override
    public Student getObjectByPhone(String phone) throws ServiceException, ServiceDaoException {
        log.info("get data :" + phone);
        Student student = null;
        if (phone == null) {
            return student;
        }
        try {
            student = (Student) dao.getMapping("getObjectByPhone",new Object[]{phone});
        } catch (DaoException e) {
        log.error(" get id wrong by phone  : " + phone);
        log.error(e);
        e.printStackTrace();
        throw new ServiceDaoException(e);
    }
        return student;
    }


    @Override
    public List<Student> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Student> student = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Student>();
        }

        try {
            student = (List<Student>) dao.getList(Student.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (student == null ? "null" : student.size()));

        return student;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getStudentIdsByJoinStatusOrderByCreateAt(Integer joinStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by joinStatus,start,limit  : " + joinStatus + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getStudentIdsByJoinStatusOrderByCreateAt", new Object[]{joinStatus}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by joinStatus,start,limit)  : " + joinStatus + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getStudentIdsByClassIdOrderByCreateAt(Long classId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by classId,start,limit  : " + classId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getStudentIdsByClassIdOrderByCreateAt", new Object[]{classId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by classId,start,limit)  : " + classId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getStudentIdsByStudyNumOrderByCreateAt(Integer studyNum, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by studyNum,start,limit  : " + studyNum + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getStudentIdsByStudyNumOrderByCreateAt", new Object[]{studyNum}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by studyNum,start,limit)  : " + studyNum + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getStudentIdsByCourseOrderByCreateAt(Integer course, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by course,start,limit  : " + course + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getStudentIdsByCourseOrderByCreateAt", new Object[]{course}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by course,start,limit)  : " + course + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getStudentIdsByStudyStatusOrderByCreateAt(Integer studyStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by studyStatus,start,limit  : " + studyStatus + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getStudentIdsByStudyStatusOrderByCreateAt", new Object[]{studyStatus}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by studyStatus,start,limit)  : " + studyStatus + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countStudentIdsByJoinStatusOrderByCreateAt(Integer joinStatus) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by joinStatus  : " + joinStatus);
        }
        Integer count = null;


        try {

            count = dao.count("getStudentIdsByJoinStatusOrderByCreateAt", new Object[]{joinStatus});


        } catch (DaoException e) {
            log.error(" count ids  wrong by joinStatus)  : " + joinStatus);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countStudentIdsByClassIdOrderByCreateAt(Long classId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by classId  : " + classId);
        }
        Integer count = null;


        try {

            count = dao.count("getStudentIdsByClassIdOrderByCreateAt", new Object[]{classId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by classId)  : " + classId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countStudentIdsByStudyNumOrderByCreateAt(Integer studyNum) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by studyNum  : " + studyNum);
        }
        Integer count = null;


        try {

            count = dao.count("getStudentIdsByStudyNumOrderByCreateAt", new Object[]{studyNum});


        } catch (DaoException e) {
            log.error(" count ids  wrong by studyNum)  : " + studyNum);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countStudentIdsByCourseOrderByCreateAt(Integer course) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by course  : " + course);
        }
        Integer count = null;


        try {

            count = dao.count("getStudentIdsByCourseOrderByCreateAt", new Object[]{course});


        } catch (DaoException e) {
            log.error(" count ids  wrong by course)  : " + course);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countStudentIdsByStudyStatusOrderByCreateAt(Integer studyStatus) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by studyStatus  : " + studyStatus);
        }
        Integer count = null;


        try {

            count = dao.count("getStudentIdsByStudyStatusOrderByCreateAt", new Object[]{studyStatus});


        } catch (DaoException e) {
            log.error(" count ids  wrong by studyStatus)  : " + studyStatus);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getStudentIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getStudentIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countStudentIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getStudentIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getStudentIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public Long getStudentIdByOpenID(String openID) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by openID  : " + openID);
        }
        Long id = null;


        try {
            id = (Long) dao.getMapping("getStudentIdByOpenID", new Object[]{openID});
        } catch (DaoException e) {
            log.error(" get id wrong by openID  : " + openID);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

}

