package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Sms;
import com.ptteng.codinglord.common.service.SmsService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.sms.service.SMSSendService;
import com.ptteng.common.sms.service.VoiceSendService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.*;


public class SmsServiceImpl extends BaseDaoServiceImpl implements SmsService {


    private static final Log log = LogFactory.getLog(SmsServiceImpl.class);

    private Map<String, String> type_template = new HashMap();

    private SMSSendService smsSendService;

    private VoiceSendService voiceSendService;


    /**
     * 模板使用，默认30分钟有效
     */
    private String registered = "注册账号";
    private String password = "找回密码";

    public SMSSendService getSmsSendService() {
        return smsSendService;
    }

    public void setSmsSendService(SMSSendService smsSendService) {
        this.smsSendService = smsSendService;
    }

    public Map<String, String> getType_template() {
        return type_template;
    }

    public void setType_template(Map<String, String> type_template) {
        this.type_template = type_template;
    }

    public VoiceSendService getVoiceSendService() {
        return voiceSendService;
    }

    public void setVoiceSendService(VoiceSendService voiceSendService) {
        this.voiceSendService = voiceSendService;
    }


    @Override
    public Long insert(Sms sms) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + sms);

        if (sms == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        sms.setCreateAt(currentTimeMillis);
        sms.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(sms);
        } catch (DaoException e) {
            log.error(" insert wrong : " + sms);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Sms> insertList(List<Sms> smsList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (smsList == null ? "null" : smsList.size()));

        List<Sms> resultList = null;

        if (CollectionUtils.isEmpty(smsList)) {
            return new ArrayList<Sms>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Sms sms : smsList) {
            sms.setCreateAt(currentTimeMillis);
            sms.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Sms>) dao.batchSave(smsList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + smsList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Sms.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Sms sms) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (sms == null ? "null" : sms.getId()));

        boolean result = false;

        if (sms == null) {
            return true;
        }

        sms.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(sms);
        } catch (DaoException e) {
            log.error(" update wrong : " + sms);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + sms);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Sms> smsList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (smsList == null ? "null" : smsList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(smsList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Sms sms : smsList) {
            sms.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(smsList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + smsList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + smsList.size());

        return result;
    }


    @Override
    public Sms getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Sms sms = null;

        if (id == null) {
            return sms;
        }

        try {
            sms = (Sms) dao.get(Sms.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return sms;
    }


    @Override
    public List<Sms> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Sms> sms = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Sms>();
        }

        try {
            sms = (List<Sms>) dao.getList(Sms.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (sms == null ? "null" : sms.size()));

        return sms;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getSmsIdByMobileAndType(String mobile, String type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by mobile,type  : " + mobile + " , " + type);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getSmsIdByMobileAndType", new Object[]{mobile, type});
        } catch (DaoException e) {
            log.error(" get id wrong by mobile,type  : " + mobile + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    @Override
    public List<Long> getSmsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getSmsIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countSmsIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getSmsIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getSmsIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    public String sendMsg(String phone, String type) throws ServiceException,
            ServiceDaoException {

        if (this.type_template.containsKey(type)) {

        } else {
            log.info(type + " is not limit ");
            return this.ErrorCode_SMS_InvalidType;
        }

        String code = "";

        String codeMessage = "";

        int count = 0;

        Sms sms = new Sms();

        Long smsId = this.getSmsIdByMobileAndType(phone, type);

        log.info("sms id is :" + smsId);

        // 已经请求过验证码
        if (smsId != null) {
            // 检验每天发送次数
            sms = this.getObjectById(smsId);

            Format formatter = new SimpleDateFormat("d");

            String ftime = formatter.format(System.currentTimeMillis());

            log.info("current time millis is :" + ftime);

            String stime = formatter.format(sms.getSendAt());

            log.info("sms send time is :" + stime);

            if (!ftime.equals(stime)) {

                sms.setCount(0);

            }
            int intNum = sms.getCount() + 1;

            log.info("sms send count is :" + intNum);

            String num = "" + intNum;

            log.info("========== num is :" + num);

            if (sms.getCount() < 5) {
                // 同类型了0分钟内验证码相同
                Long delay = System.currentTimeMillis() - sms.getTypeSendAt();

                log.info("delay is :" + delay);

                if (delay <= 900000) {

                    log.info("15分钟内发送相同验证码");

                    code = sms.getMessage();

                    log.info("sms info is :" + code);

                    String returnString = "";

                    if (type.equals("register")) {

                        returnString = sendSms(phone, type, new String[]{"【编程王】您的验证码为" + code +",请于五分钟内正确输入，如非本人操作，请忽略此短信"});

                    } else {


                    }
                    log.info("短信发送返回值：" + returnString);

                    // TODO 处理返回值,参见HTTP协议文档

                    sms.setSendAt(System.currentTimeMillis());

                    count = sms.getCount();

                    count += 1;

                    sms.setCount(count);

                    log.info("信息发送成功");


                } else {
                    // 生成验证码
                    Random rand = new Random();
                    for (int i = 0; i < 6; i++) {
                        code = code + rand.nextInt(10);
                    }
                    code = code.trim();

                    log.info("code is :" + code);

                    String returnString = "";

                    if (type.equals("register")) {

                        returnString = sendSms(phone, type, new String[]{"【编程王】您的验证码为" + code +",请于五分钟内正确输入，如非本人操作，请忽略此短信"});

                    } else {

                    }
                    log.info("短信发送返回值：" + returnString);

                    // TODO 处理返回值,参见HTTP协议文档;

                    sms.setSendAt(System.currentTimeMillis());

                    sms.setTypeSendAt(System.currentTimeMillis());

                    count = sms.getCount();

                    count += 1;

                    sms.setCount(count);

                    sms.setMessage(code);

                    log.info("超过30分钟发送新验证码");

                }
                this.update(sms);
            } else {
                log.info("count > 5 ");

                return this.ErrorCode_SMS_smsMoreThan5;
            }

            // 第一次发送请求
        } else {

            // 生成验证码

            Random rand = new Random();
            for (int i = 0; i < 6; i++) {
                code = code + rand.nextInt(10);
            }
            code = code.trim();
//            codeMessage = "您在技能树请求的验证码为:"+code;
            sms.setCount(0);
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;

            // 发送短信

            String returnString = "";
            try {
//                returnString = sendSms(phone, type, new String[]{codeMessage, num, this.timeLimit});
                if (type.equals("register")) {

                    returnString = sendSms(phone, type,new String[]{"【编程王】您的验证码为" + code +",请于五分钟内正确输入，如非本人操作，请忽略此短信"});
                } else {


                }
                log.info("短信发送返回值：" + returnString);
                // TODO 处理返回值,参见HTTP协议文档
                count += 1;
                // 保存sms对象信息
                sms.setMobile(phone);
                sms.setType(type);
                sms.setMessage(code);
                sms.setSendAt(System.currentTimeMillis());
                sms.setTypeSendAt(System.currentTimeMillis());
                sms.setCount(count);
                Long ms = this.insert(sms);
                log.info("发送成功！ 信息保存结果：" + ms);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }

        return "";
    }

    private String sendSms(String phone, String type, String[] params) {
        String template = this.type_template.get(type);
        log.info(phone + " and type is " + type + " params " + Arrays.asList(params) + " template " + template);
        String returnString = null;
        try {
            returnString = this.smsSendService.sendSMSByTemplate(phone,
                    template, params);
            return returnString;
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return returnString;
        }

    }

    @Override
    public String sendVoice(String phone, String type) throws ServiceException, ServiceDaoException {
        if (this.type_template.containsKey(type)) {

        } else {
            log.info(type + " is not limit ");
            return this.ErrorCode_SMS_InvalidType;
        }

        String code = "";
        int count = 0;
        Sms sms = new Sms();
        Long smsId = this.getSmsIdByMobileAndType(phone, type);


        // 已经请求过验证码
        if (smsId != null) {
            // 检验每天发送次数
            sms = this.getObjectById(smsId);
            Format formatter = new SimpleDateFormat("d");
            String ftime = formatter.format(System.currentTimeMillis());
            String stime = formatter.format(sms.getSendAt());
            if (!ftime.equals(stime)) {
                sms.setCount(0);
            }
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;
            if (sms.getCount() < 5) {
                // 同类型30分钟内验证码相同
                Long delay = System.currentTimeMillis() - sms.getTypeSendAt();
                if (delay <= 1800000) {
                    log.info("30分钟内发送相同验证码");
                    code = sms.getMessage();
                    String sendResult = voiceSendService.sendVoice(phone, code);
                    log.info("sendResult：" + sendResult);
                    if (sendResult.startsWith("Error")) {
                        return this.ErrorCode_sendError;
                    }
                    sms.setSendAt(System.currentTimeMillis());
                    count = sms.getCount();
                    count += 1;
                    sms.setCount(count);
                    log.info("语音发送成功");
                } else {
                    // 生成验证码
                    Random rand = new Random();
                    for (int i = 0; i < 6; i++) {
                        code = code + rand.nextInt(10);
                    }
                    code = code.trim();
                    String sendResult = voiceSendService.sendVoice(phone, code);
                    log.info("sendResult：" + sendResult);
                    if (sendResult.startsWith("Error")) {
                        return this.ErrorCode_sendError;
                    }
                    sms.setSendAt(System.currentTimeMillis());
                    sms.setTypeSendAt(System.currentTimeMillis());
                    count = sms.getCount();
                    count += 1;
                    sms.setCount(count);
                    sms.setMessage(code);
                    log.info("超过30分钟发送新验证码");

                }
                this.update(sms);
            } else {
                log.info("count > 5 ");
                return this.ErrorCode_SMS_smsMoreThan5;
            }

            // 第一次发送请求
        } else {

            // 生成验证码

            Random rand = new Random();
            for (int i = 0; i < 6; i++) {
                code = code + rand.nextInt(10);
            }
            code = code.trim();
            sms.setCount(0);
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;

            // 发送短信

            try {
                String sendResult = voiceSendService.sendVoice(phone, code);
                log.info("sendResult：" + sendResult);
                if (sendResult.startsWith("Error")) {
                    return this.ErrorCode_sendError;
                }
                count += 1;
                // 保存sms对象信息
                sms.setMobile(phone);
                sms.setType(type);
                sms.setMessage(code);
                sms.setSendAt(System.currentTimeMillis());
                sms.setTypeSendAt(System.currentTimeMillis());
                sms.setCount(count);
                Long ms = this.insert(sms);
                log.info("发送成功！ 保存结果：" + ms);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }


        return "";
    }

}

