package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.SchoolSubjectRelation;
import com.ptteng.codinglord.common.service.SchoolSubjectRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class SchoolSubjectRelationServiceImpl extends BaseDaoServiceImpl implements SchoolSubjectRelationService {

 

	private static final Log log = LogFactory.getLog(SchoolSubjectRelationServiceImpl.class);



		   
		@Override
		public Long insert(SchoolSubjectRelation schoolSubjectRelation)throws ServiceException, ServiceDaoException {
		
	
		          
    log.info(" insert data : " + schoolSubjectRelation);

		if (schoolSubjectRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		schoolSubjectRelation.setCreateAt(currentTimeMillis);
		schoolSubjectRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(schoolSubjectRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + schoolSubjectRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<SchoolSubjectRelation> insertList(List<SchoolSubjectRelation> schoolSubjectRelationList)throws ServiceException, ServiceDaoException {
		
	
		          	
        log.info(" insert lists : " + (schoolSubjectRelationList == null ? "null" : schoolSubjectRelationList.size()));
      
		List<SchoolSubjectRelation> resultList = null;

		if (CollectionUtils.isEmpty(schoolSubjectRelationList)) {
			return new ArrayList<SchoolSubjectRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (SchoolSubjectRelation schoolSubjectRelation : schoolSubjectRelationList) {
			schoolSubjectRelation.setCreateAt(currentTimeMillis);
			schoolSubjectRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<SchoolSubjectRelation>) dao.batchSave(schoolSubjectRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + schoolSubjectRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException {
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(SchoolSubjectRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(SchoolSubjectRelation schoolSubjectRelation)throws ServiceException, ServiceDaoException {
		
	
		          
	log.info(" update data : " + (schoolSubjectRelation == null ? "null" : schoolSubjectRelation.getId()));

		boolean result = false;

		if (schoolSubjectRelation == null) {
			return true;
		}

		schoolSubjectRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(schoolSubjectRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + schoolSubjectRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + schoolSubjectRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<SchoolSubjectRelation> schoolSubjectRelationList)throws ServiceException, ServiceDaoException {
		
	
		          log.info(" update lists : " + (schoolSubjectRelationList == null ? "null" : schoolSubjectRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(schoolSubjectRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (SchoolSubjectRelation schoolSubjectRelation : schoolSubjectRelationList) {
			schoolSubjectRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(schoolSubjectRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + schoolSubjectRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + schoolSubjectRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public SchoolSubjectRelation getObjectById(Long id)throws ServiceException, ServiceDaoException {
		
	
		              
        log.info(" get data : " + id);
      
		SchoolSubjectRelation schoolSubjectRelation = null;

		if (id == null) {
			return schoolSubjectRelation;
		}

		try {
			schoolSubjectRelation = (SchoolSubjectRelation) dao.get(SchoolSubjectRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return schoolSubjectRelation;		
		}	
		  
    	   
		@Override
		public List<SchoolSubjectRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException {
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<SchoolSubjectRelation> schoolSubjectRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<SchoolSubjectRelation>();
		}

		try {
			schoolSubjectRelation = (List<SchoolSubjectRelation>) dao.getList(SchoolSubjectRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (schoolSubjectRelation == null ? "null" : schoolSubjectRelation.size()));
    
		return schoolSubjectRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSubjectIdsBySchoolIdOrderByCreateAt(Long schoolId,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get subjectIds by schoolId,start,limit  : " + schoolId+" , "+start+" , "+limit );
	  }
	 	List<Long> subjectIdList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		subjectIdList = dao.getIdList("getSubjectIdsBySchoolIdOrderByCreateAt", new Object[] { schoolId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get subjectIds  wrong by schoolId,start,limit)  : " + schoolId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get subjectIds success : " + (subjectIdList == null ? "null" : subjectIdList.size()));
  }
		return subjectIdList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSchoolSubjectRelationIdsBySchoolIdOrderByCreateAt(Long schoolId,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by schoolId,start,limit  : " + schoolId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getSchoolSubjectRelationIdsBySchoolIdOrderByCreateAt", new Object[] { schoolId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by schoolId,start,limit)  : " + schoolId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSubjectIdsBySchoolIdOrderByCreateAt(Long schoolId)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count subjectIds by schoolId  : " + schoolId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getSubjectIdsBySchoolIdOrderByCreateAt", new Object[] { schoolId});

   
   } catch (DaoException e) {
			log.error(" count subjectIds  wrong by schoolId)  : " + schoolId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSchoolSubjectRelationIdsBySchoolIdOrderByCreateAt(Long schoolId)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by schoolId  : " + schoolId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getSchoolSubjectRelationIdsBySchoolIdOrderByCreateAt", new Object[] { schoolId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by schoolId)  : " + schoolId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getSchoolSubjectRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getSchoolSubjectRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countSchoolSubjectRelationIds() throws ServiceException,
                ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getSchoolSubjectRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getSchoolSubjectRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

