package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.ProductionStudentRelation;
import com.ptteng.codinglord.common.service.ProductionStudentRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ProductionStudentRelationServiceImpl extends BaseDaoServiceImpl implements ProductionStudentRelationService {

 

	private static final Log log = LogFactory.getLog(ProductionStudentRelationServiceImpl.class);



		   
		@Override
		public Long insert(ProductionStudentRelation productionStudentRelation)throws ServiceException, ServiceDaoException {
		
	
		          
    log.info(" insert data : " + productionStudentRelation);

		if (productionStudentRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		productionStudentRelation.setCreateAt(currentTimeMillis);
		productionStudentRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(productionStudentRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + productionStudentRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ProductionStudentRelation> insertList(List<ProductionStudentRelation> productionStudentRelationList)throws ServiceException, ServiceDaoException {
		
	
		          	
        log.info(" insert lists : " + (productionStudentRelationList == null ? "null" : productionStudentRelationList.size()));
      
		List<ProductionStudentRelation> resultList = null;

		if (CollectionUtils.isEmpty(productionStudentRelationList)) {
			return new ArrayList<ProductionStudentRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProductionStudentRelation productionStudentRelation : productionStudentRelationList) {
			productionStudentRelation.setCreateAt(currentTimeMillis);
			productionStudentRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ProductionStudentRelation>) dao.batchSave(productionStudentRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + productionStudentRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException {
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ProductionStudentRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ProductionStudentRelation productionStudentRelation)throws ServiceException, ServiceDaoException {
		
	
		          
	log.info(" update data : " + (productionStudentRelation == null ? "null" : productionStudentRelation.getId()));

		boolean result = false;

		if (productionStudentRelation == null) {
			return true;
		}

		productionStudentRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(productionStudentRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + productionStudentRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + productionStudentRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ProductionStudentRelation> productionStudentRelationList)throws ServiceException, ServiceDaoException {
		
	
		          log.info(" update lists : " + (productionStudentRelationList == null ? "null" : productionStudentRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(productionStudentRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProductionStudentRelation productionStudentRelation : productionStudentRelationList) {
			productionStudentRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(productionStudentRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + productionStudentRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + productionStudentRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ProductionStudentRelation getObjectById(Long id)throws ServiceException, ServiceDaoException {
		
	
		              
        log.info(" get data : " + id);
      
		ProductionStudentRelation productionStudentRelation = null;

		if (id == null) {
			return productionStudentRelation;
		}

		try {
			productionStudentRelation = (ProductionStudentRelation) dao.get(ProductionStudentRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return productionStudentRelation;		
		}	
		  
    	   
		@Override
		public List<ProductionStudentRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException {
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ProductionStudentRelation> productionStudentRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ProductionStudentRelation>();
		}

		try {
			productionStudentRelation = (List<ProductionStudentRelation>) dao.getList(ProductionStudentRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (productionStudentRelation == null ? "null" : productionStudentRelation.size()));
    
		return productionStudentRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProductionStudentRelationIdsByStudentIdAndRelationTypeOrderByCreateAt(Long studentId,Integer relationType,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by studentId,relationType,start,limit  : " + studentId+" , "+relationType+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProductionStudentRelationIdsByStudentIdAndRelationTypeOrderByCreateAt", new Object[] { studentId,relationType},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by studentId,relationType,start,limit)  : " + studentId+" , "+relationType+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProductionIdsByStudentIdAndRelationTypeOrderByCreateAt(Long studentId,Integer relationType,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get productionIds by studentId,relationType,start,limit  : " + studentId+" , "+relationType+" , "+start+" , "+limit );
	  }
	 	List<Long> productionIdList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		productionIdList = dao.getIdList("getProductionIdsByStudentIdAndRelationTypeOrderByCreateAt", new Object[] { studentId,relationType},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get productionIds  wrong by studentId,relationType,start,limit)  : " + studentId+" , "+relationType+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get productionIds success : " + (productionIdList == null ? "null" : productionIdList.size()));
  }
		return productionIdList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProductionStudentRelationIdsByStudentIdAndRelationTypeOrderByCreateAt(Long studentId,Integer relationType)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by studentId,relationType  : " + studentId+" , "+relationType );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProductionStudentRelationIdsByStudentIdAndRelationTypeOrderByCreateAt", new Object[] { studentId,relationType});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by studentId,relationType)  : " + studentId+" , "+relationType );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProductionIdsByStudentIdAndRelationTypeOrderByCreateAt(Long studentId,Integer relationType)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count productionIds by studentId,relationType  : " + studentId+" , "+relationType );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProductionIdsByStudentIdAndRelationTypeOrderByCreateAt", new Object[] { studentId,relationType});

   
   } catch (DaoException e) {
			log.error(" count productionIds  wrong by studentId,relationType)  : " + studentId+" , "+relationType );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getProductionStudentRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getProductionStudentRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countProductionStudentRelationIds() throws ServiceException,
                ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getProductionStudentRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getProductionStudentRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

