package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;

import com.ptteng.codinglord.common.model.Preview;
import com.ptteng.codinglord.common.service.PreviewService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class PreviewServiceImpl extends BaseDaoServiceImpl implements PreviewService {


    private static final Log log = LogFactory.getLog(PreviewServiceImpl.class);


    @Override
    public List<Long>getIdByClassId(Long classId) throws ServiceException, ServiceDaoException {
        log.info("select classId is :" + classId);
        List<Long> ids = new ArrayList<>();
        try {
            ids = dao.getIdList("getPreviewByClassId", new Object[]{classId},0, Integer.MAX_VALUE, false);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        return ids;
    }

    @Override
    public Long insert(Preview preview) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + preview);

        if (preview == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        preview.setCreateAt(currentTimeMillis);
        preview.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(preview);
        } catch (DaoException e) {
            log.error(" insert wrong : " + preview);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Preview> insertList(List<Preview> previewList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (previewList == null ? "null" : previewList.size()));

        List<Preview> resultList = null;

        if (CollectionUtils.isEmpty(previewList)) {
            return new ArrayList<Preview>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Preview preview : previewList) {
            preview.setCreateAt(currentTimeMillis);
            preview.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Preview>) dao.batchSave(previewList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + previewList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Preview.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Preview preview) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (preview == null ? "null" : preview.getId()));

        boolean result = false;

        if (preview == null) {
            return true;
        }

        preview.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(preview);
        } catch (DaoException e) {
            log.error(" update wrong : " + preview);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + preview);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Preview> previewList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (previewList == null ? "null" : previewList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(previewList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Preview preview : previewList) {
            preview.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(previewList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + previewList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + previewList.size());

        return result;
    }


    @Override
    public Preview getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Preview preview = null;

        if (id == null) {
            return preview;
        }

        try {
            preview = (Preview) dao.get(Preview.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return preview;
    }


    @Override
    public List<Preview> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Preview> preview = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Preview>();
        }

        try {
            preview = (List<Preview>) dao.getList(Preview.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (preview == null ? "null" : preview.size()));

        return preview;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getPreviewIdsByCourseOrderByCreateAt(Integer course, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by course,start,limit  : " + course + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getPreviewIdsByCourseOrderByCreateAt", new Object[]{course}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by course,start,limit)  : " + course + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getPreviewIdsByClassIdOrderByCreateAt(Long classId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by classId,start,limit  : " + classId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getPreviewIdsByClassIdOrderByCreateAt", new Object[]{classId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by classId,start,limit)  : " + classId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countPreviewIdsByCourseOrderByCreateAt(Integer course) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by course  : " + course);
        }
        Integer count = null;


        try {

            count = dao.count("getPreviewIdsByCourseOrderByCreateAt", new Object[]{course});


        } catch (DaoException e) {
            log.error(" count ids  wrong by course)  : " + course);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countPreviewIdsByClassIdOrderByCreateAt(Long classId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by classId  : " + classId);
        }
        Integer count = null;


        try {

            count = dao.count("getPreviewIdsByClassIdOrderByCreateAt", new Object[]{classId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by classId)  : " + classId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getPreviewIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getPreviewIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countPreviewIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getPreviewIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getPreviewIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

