package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Period;
import com.ptteng.codinglord.common.service.PeriodService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class PeriodServiceImpl extends BaseDaoServiceImpl implements PeriodService {

 

	private static final Log log = LogFactory.getLog(PeriodServiceImpl.class);



		   
		@Override
		public Long insert(Period period)throws ServiceException, ServiceDaoException {
		
	
		          
    log.info(" insert data : " + period);

		if (period == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		period.setCreateAt(currentTimeMillis);
		period.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(period);
		} catch (DaoException e) {
			log.error(" insert wrong : " + period);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Period> insertList(List<Period> periodList)throws ServiceException, ServiceDaoException {
		
	
		          	
        log.info(" insert lists : " + (periodList == null ? "null" : periodList.size()));
      
		List<Period> resultList = null;

		if (CollectionUtils.isEmpty(periodList)) {
			return new ArrayList<Period>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Period period : periodList) {
			period.setCreateAt(currentTimeMillis);
			period.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Period>) dao.batchSave(periodList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + periodList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException {
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Period.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Period period)throws ServiceException, ServiceDaoException {
		
	
		          
	log.info(" update data : " + (period == null ? "null" : period.getId()));

		boolean result = false;

		if (period == null) {
			return true;
		}

		period.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(period);
		} catch (DaoException e) {
			log.error(" update wrong : " + period);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + period);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Period> periodList)throws ServiceException, ServiceDaoException {
		
	
		          log.info(" update lists : " + (periodList == null ? "null" : periodList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(periodList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Period period : periodList) {
			period.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(periodList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + periodList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + periodList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Period getObjectById(Long id)throws ServiceException, ServiceDaoException {
		
	
		              
        log.info(" get data : " + id);
      
		Period period = null;

		if (id == null) {
			return period;
		}

		try {
			period = (Period) dao.get(Period.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return period;		
		}	
		  
    	   
		@Override
		public List<Period> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException {
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Period> period = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Period>();
		}

		try {
			period = (List<Period>) dao.getList(Period.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (period == null ? "null" : period.size()));
    
		return period;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getPeriodIdsByChapterIdOrderByCreateAt(Long chapterId,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by chapterId,start,limit  : " + chapterId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getPeriodIdsByChapterIdOrderByCreateAt", new Object[] { chapterId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by chapterId,start,limit)  : " + chapterId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getPeriodIdsByStatusAndChapterIdOrderByCreateAt(Integer status,Long chapterId,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by status,chapterId,start,limit  : " + status+" , "+chapterId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getPeriodIdsByStatusAndChapterIdOrderByCreateAt", new Object[] { status,chapterId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by status,chapterId,start,limit)  : " + status+" , "+chapterId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countPeriodIdsByChapterIdOrderByCreateAt(Long chapterId)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by chapterId  : " + chapterId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getPeriodIdsByChapterIdOrderByCreateAt", new Object[] { chapterId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by chapterId)  : " + chapterId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countPeriodIdsByStatusAndChapterIdOrderByCreateAt(Integer status,Long chapterId)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by status,chapterId  : " + status+" , "+chapterId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getPeriodIdsByStatusAndChapterIdOrderByCreateAt", new Object[] { status,chapterId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by status,chapterId)  : " + status+" , "+chapterId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getPeriodIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getPeriodIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countPeriodIds() throws ServiceException,
                ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getPeriodIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getPeriodIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

