package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.CourseStudentRelation;
import com.ptteng.codinglord.common.service.CourseStudentRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class CourseStudentRelationServiceImpl extends BaseDaoServiceImpl implements CourseStudentRelationService {

 

	private static final Log log = LogFactory.getLog(CourseStudentRelationServiceImpl.class);



		   
		@Override
		public Long insert(CourseStudentRelation courseStudentRelation)throws ServiceException, ServiceDaoException {
		
	
		          
    log.info(" insert data : " + courseStudentRelation);

		if (courseStudentRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		courseStudentRelation.setCreateAt(currentTimeMillis);
		courseStudentRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(courseStudentRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + courseStudentRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<CourseStudentRelation> insertList(List<CourseStudentRelation> courseStudentRelationList)throws ServiceException, ServiceDaoException {
		
	
		          	
        log.info(" insert lists : " + (courseStudentRelationList == null ? "null" : courseStudentRelationList.size()));
      
		List<CourseStudentRelation> resultList = null;

		if (CollectionUtils.isEmpty(courseStudentRelationList)) {
			return new ArrayList<CourseStudentRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CourseStudentRelation courseStudentRelation : courseStudentRelationList) {
			courseStudentRelation.setCreateAt(currentTimeMillis);
			courseStudentRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<CourseStudentRelation>) dao.batchSave(courseStudentRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + courseStudentRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException {
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(CourseStudentRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(CourseStudentRelation courseStudentRelation)throws ServiceException, ServiceDaoException {
		
	
		          
	log.info(" update data : " + (courseStudentRelation == null ? "null" : courseStudentRelation.getId()));

		boolean result = false;

		if (courseStudentRelation == null) {
			return true;
		}

		courseStudentRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(courseStudentRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + courseStudentRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + courseStudentRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<CourseStudentRelation> courseStudentRelationList)throws ServiceException, ServiceDaoException {
		
	
		          log.info(" update lists : " + (courseStudentRelationList == null ? "null" : courseStudentRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(courseStudentRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CourseStudentRelation courseStudentRelation : courseStudentRelationList) {
			courseStudentRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(courseStudentRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + courseStudentRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + courseStudentRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public CourseStudentRelation getObjectById(Long id)throws ServiceException, ServiceDaoException {
		
	
		              
        log.info(" get data : " + id);
      
		CourseStudentRelation courseStudentRelation = null;

		if (id == null) {
			return courseStudentRelation;
		}

		try {
			courseStudentRelation = (CourseStudentRelation) dao.get(CourseStudentRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return courseStudentRelation;		
		}	
		  
    	   
		@Override
		public List<CourseStudentRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException {
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<CourseStudentRelation> courseStudentRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<CourseStudentRelation>();
		}

		try {
			courseStudentRelation = (List<CourseStudentRelation>) dao.getList(CourseStudentRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (courseStudentRelation == null ? "null" : courseStudentRelation.size()));
    
		return courseStudentRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCourseIdsByStudentIdAndRelationTypeOrderByCreateAt(Long studentId,Integer relationType,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get courseIds by studentId,relationType,start,limit  : " + studentId+" , "+relationType+" , "+start+" , "+limit );
	  }
	 	List<Long> courseIdList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		courseIdList = dao.getIdList("getCourseIdsByStudentIdAndRelationTypeOrderByCreateAt", new Object[] { studentId,relationType},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get courseIds  wrong by studentId,relationType,start,limit)  : " + studentId+" , "+relationType+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get courseIds success : " + (courseIdList == null ? "null" : courseIdList.size()));
  }
		return courseIdList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCourseIdsByStudentIdAndRelationTypeOrderByCreateAt(Long studentId,Integer relationType)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count courseIds by studentId,relationType  : " + studentId+" , "+relationType );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCourseIdsByStudentIdAndRelationTypeOrderByCreateAt", new Object[] { studentId,relationType});

   
   } catch (DaoException e) {
			log.error(" count courseIds  wrong by studentId,relationType)  : " + studentId+" , "+relationType );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getCourseStudentRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCourseStudentRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCourseStudentRelationIds() throws ServiceException,
                ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCourseStudentRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCourseStudentRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

