package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Course;
import com.ptteng.codinglord.common.service.CourseService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class CourseServiceImpl extends BaseDaoServiceImpl implements CourseService {

 

	private static final Log log = LogFactory.getLog(CourseServiceImpl.class);



		   
		@Override
		public Long insert(Course course)throws ServiceException, ServiceDaoException {
		
	
		          
    log.info(" insert data : " + course);

		if (course == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		course.setCreateAt(currentTimeMillis);
		course.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(course);
		} catch (DaoException e) {
			log.error(" insert wrong : " + course);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Course> insertList(List<Course> courseList)throws ServiceException, ServiceDaoException {
		
	
		          	
        log.info(" insert lists : " + (courseList == null ? "null" : courseList.size()));
      
		List<Course> resultList = null;

		if (CollectionUtils.isEmpty(courseList)) {
			return new ArrayList<Course>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Course course : courseList) {
			course.setCreateAt(currentTimeMillis);
			course.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Course>) dao.batchSave(courseList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + courseList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException {
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Course.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Course course)throws ServiceException, ServiceDaoException {
		
	
		          
	log.info(" update data : " + (course == null ? "null" : course.getId()));

		boolean result = false;

		if (course == null) {
			return true;
		}

		course.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(course);
		} catch (DaoException e) {
			log.error(" update wrong : " + course);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + course);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Course> courseList)throws ServiceException, ServiceDaoException {
		
	
		          log.info(" update lists : " + (courseList == null ? "null" : courseList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(courseList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Course course : courseList) {
			course.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(courseList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + courseList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + courseList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Course getObjectById(Long id)throws ServiceException, ServiceDaoException {
		
	
		              
        log.info(" get data : " + id);
      
		Course course = null;

		if (id == null) {
			return course;
		}

		try {
			course = (Course) dao.get(Course.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return course;		
		}	
		  
    	   
		@Override
		public List<Course> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException {
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Course> course = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Course>();
		}

		try {
			course = (List<Course>) dao.getList(Course.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (course == null ? "null" : course.size()));
    
		return course;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCourseIdsByTypeOrderByCreateAt(Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by type,start,limit  : " + type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCourseIdsByTypeOrderByCreateAt", new Object[] { type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by type,start,limit)  : " + type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCourseIdsByStatusOrderByCreateAt(Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by status,start,limit  : " + status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCourseIdsByStatusOrderByCreateAt", new Object[] { status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by status,start,limit)  : " + status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCourseIdsByTypeOrderByCreateAt(Integer type)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by type  : " + type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCourseIdsByTypeOrderByCreateAt", new Object[] { type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by type)  : " + type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCourseIdsByStatusOrderByCreateAt(Integer status)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by status  : " + status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCourseIdsByStatusOrderByCreateAt", new Object[] { status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by status)  : " + status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getCourseIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCourseIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCourseIds() throws ServiceException,
                ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCourseIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCourseIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

