package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Classes;
import com.ptteng.codinglord.common.service.ClassesService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ClassesServiceImpl extends BaseDaoServiceImpl implements ClassesService {

 

	private static final Log log = LogFactory.getLog(ClassesServiceImpl.class);



		   
		@Override
		public Long insert(Classes classesEntity)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + classesEntity);

		if (classesEntity == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
			classesEntity.setCreateAt(currentTimeMillis);
			classesEntity.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(classesEntity);
		} catch (DaoException e) {
			log.error(" insert wrong : " + classesEntity);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Classes> insertList(List<Classes> classesList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (classesList == null ? "null" : classesList.size()));
      
		List<Classes> resultList = null;

		if (CollectionUtils.isEmpty(classesList)) {
			return new ArrayList<Classes>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Classes classesEntity : classesList) {
			classesEntity.setCreateAt(currentTimeMillis);
			classesEntity.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Classes>) dao.batchSave(classesList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + classesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Classes.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Classes classesEntity)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (classesEntity == null ? "null" : classesEntity.getId()));

		boolean result = false;

		if (classesEntity == null) {
			return true;
		}

			classesEntity.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(classesEntity);
		} catch (DaoException e) {
			log.error(" update wrong : " + classesEntity);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + classesEntity);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Classes> classesList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (classesList == null ? "null" : classesList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(classesList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Classes classesEntity : classesList) {
			classesEntity.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(classesList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + classesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + classesList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Classes getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Classes classesEntity = null;

		if (id == null) {
			return classesEntity;
		}

		try {
			classesEntity = (Classes) dao.get(Classes.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return classesEntity;
		}	
		  
    	   
		@Override
		public List<Classes> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Classes> classesEntity = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Classes>();
		}

		try {
			classesEntity = (List<Classes>) dao.getList(Classes.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (classesEntity == null ? "null" : classesEntity.size()));
    
		return classesEntity;
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getClassesIdsByClassNumOrderByCreateAt(Integer classNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by classNum,start,limit  : " + classNum+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getClassesIdsByClassNumOrderByCreateAt", new Object[] { classNum},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by classesNum,start,limit)  : " + classNum+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countClassesIdsByClassNumOrderByCreateAt(Integer classNum)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by classNum  : " + classNum );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getClassesIdsByClassNumOrderByCreateAt", new Object[] { classNum});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by classNum)  : " + classNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getClassesIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getClassesIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countClassesIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getClassesIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getClassIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

