package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Chapter;
import com.ptteng.codinglord.common.service.ChapterService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ChapterServiceImpl extends BaseDaoServiceImpl implements ChapterService {

 

	private static final Log log = LogFactory.getLog(ChapterServiceImpl.class);



		   
		@Override
		public Long insert(Chapter chapter)throws ServiceException, ServiceDaoException {
		
	
		          
    log.info(" insert data : " + chapter);

		if (chapter == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		chapter.setCreateAt(currentTimeMillis);
		chapter.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(chapter);
		} catch (DaoException e) {
			log.error(" insert wrong : " + chapter);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Chapter> insertList(List<Chapter> chapterList)throws ServiceException, ServiceDaoException {
		
	
		          	
        log.info(" insert lists : " + (chapterList == null ? "null" : chapterList.size()));
      
		List<Chapter> resultList = null;

		if (CollectionUtils.isEmpty(chapterList)) {
			return new ArrayList<Chapter>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Chapter chapter : chapterList) {
			chapter.setCreateAt(currentTimeMillis);
			chapter.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Chapter>) dao.batchSave(chapterList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + chapterList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException {
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Chapter.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Chapter chapter)throws ServiceException, ServiceDaoException {
		
	
		          
	log.info(" update data : " + (chapter == null ? "null" : chapter.getId()));

		boolean result = false;

		if (chapter == null) {
			return true;
		}

		chapter.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(chapter);
		} catch (DaoException e) {
			log.error(" update wrong : " + chapter);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + chapter);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Chapter> chapterList)throws ServiceException, ServiceDaoException {
		
	
		          log.info(" update lists : " + (chapterList == null ? "null" : chapterList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(chapterList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Chapter chapter : chapterList) {
			chapter.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(chapterList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + chapterList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + chapterList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Chapter getObjectById(Long id)throws ServiceException, ServiceDaoException {
		
	
		              
        log.info(" get data : " + id);
      
		Chapter chapter = null;

		if (id == null) {
			return chapter;
		}

		try {
			chapter = (Chapter) dao.get(Chapter.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return chapter;		
		}	
		  
    	   
		@Override
		public List<Chapter> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException {
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Chapter> chapter = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Chapter>();
		}

		try {
			chapter = (List<Chapter>) dao.getList(Chapter.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (chapter == null ? "null" : chapter.size()));
    
		return chapter;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getChapterIdsByStatusAndCourseIdOrderByCreateAt(Integer status,Long courseId,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by status,courseId,start,limit  : " + status+" , "+courseId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getChapterIdsByStatusAndCourseIdOrderByCreateAt", new Object[] { status,courseId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by status,courseId,start,limit)  : " + status+" , "+courseId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getChapterIdsByCourseIdOrderByCreateAt(Long courseId,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by courseId,start,limit  : " + courseId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getChapterIdsByCourseIdOrderByCreateAt", new Object[] { courseId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by courseId,start,limit)  : " + courseId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countChapterIdsByStatusAndCourseIdOrderByCreateAt(Integer status,Long courseId)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by status,courseId  : " + status+" , "+courseId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getChapterIdsByStatusAndCourseIdOrderByCreateAt", new Object[] { status,courseId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by status,courseId)  : " + status+" , "+courseId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countChapterIdsByCourseIdOrderByCreateAt(Long courseId)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by courseId  : " + courseId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getChapterIdsByCourseIdOrderByCreateAt", new Object[] { courseId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by courseId)  : " + courseId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getChapterIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getChapterIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countChapterIds() throws ServiceException,
                ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getChapterIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getChapterIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

