package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.CardSpecies;
import com.ptteng.codinglord.common.service.CardSpeciesService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class CardSpeciesServiceImpl extends BaseDaoServiceImpl implements CardSpeciesService {

 

	private static final Log log = LogFactory.getLog(CardSpeciesServiceImpl.class);



		   
		@Override
		public Long insert(CardSpecies cardSpecies)throws ServiceException, ServiceDaoException {
		
	
		          
    log.info(" insert data : " + cardSpecies);

		if (cardSpecies == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		cardSpecies.setCreateAt(currentTimeMillis);
		cardSpecies.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(cardSpecies);
		} catch (DaoException e) {
			log.error(" insert wrong : " + cardSpecies);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<CardSpecies> insertList(List<CardSpecies> cardSpeciesList)throws ServiceException, ServiceDaoException {
		
	
		          	
        log.info(" insert lists : " + (cardSpeciesList == null ? "null" : cardSpeciesList.size()));
      
		List<CardSpecies> resultList = null;

		if (CollectionUtils.isEmpty(cardSpeciesList)) {
			return new ArrayList<CardSpecies>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CardSpecies cardSpecies : cardSpeciesList) {
			cardSpecies.setCreateAt(currentTimeMillis);
			cardSpecies.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<CardSpecies>) dao.batchSave(cardSpeciesList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + cardSpeciesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException {
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(CardSpecies.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(CardSpecies cardSpecies)throws ServiceException, ServiceDaoException {
		
	
		          
	log.info(" update data : " + (cardSpecies == null ? "null" : cardSpecies.getId()));

		boolean result = false;

		if (cardSpecies == null) {
			return true;
		}

		cardSpecies.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(cardSpecies);
		} catch (DaoException e) {
			log.error(" update wrong : " + cardSpecies);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + cardSpecies);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<CardSpecies> cardSpeciesList)throws ServiceException, ServiceDaoException {
		
	
		          log.info(" update lists : " + (cardSpeciesList == null ? "null" : cardSpeciesList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(cardSpeciesList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CardSpecies cardSpecies : cardSpeciesList) {
			cardSpecies.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(cardSpeciesList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + cardSpeciesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + cardSpeciesList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public CardSpecies getObjectById(Long id)throws ServiceException, ServiceDaoException {
		
	
		              
        log.info(" get data : " + id);
      
		CardSpecies cardSpecies = null;

		if (id == null) {
			return cardSpecies;
		}

		try {
			cardSpecies = (CardSpecies) dao.get(CardSpecies.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return cardSpecies;		
		}	
		  
    	   
		@Override
		public List<CardSpecies> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException {
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<CardSpecies> cardSpecies = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<CardSpecies>();
		}

		try {
			cardSpecies = (List<CardSpecies>) dao.getList(CardSpecies.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (cardSpecies == null ? "null" : cardSpecies.size()));
    
		return cardSpecies;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCardSpeciesIdsByStatusOrderByCreateAt(Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by status,start,limit  : " + status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCardSpeciesIdsByStatusOrderByCreateAt", new Object[] { status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by status,start,limit)  : " + status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCardSpeciesIdsByStatusOrderByCreateAt(Integer status)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by status  : " + status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCardSpeciesIdsByStatusOrderByCreateAt", new Object[] { status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by status)  : " + status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getCardSpeciesIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCardSpeciesIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCardSpeciesIds() throws ServiceException,
                ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCardSpeciesIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCardSpeciesIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

