package com.ptteng.codinglord.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.codinglord.common.model.Card;
import com.ptteng.codinglord.common.service.CardService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class CardServiceImpl extends BaseDaoServiceImpl implements CardService {

 

	private static final Log log = LogFactory.getLog(CardServiceImpl.class);



		   
		@Override
		public Long insert(Card card)throws ServiceException, ServiceDaoException {
		
	
		          
    log.info(" insert data : " + card);

		if (card == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		card.setCreateAt(currentTimeMillis);
		card.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(card);
		} catch (DaoException e) {
			log.error(" insert wrong : " + card);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Card> insertList(List<Card> cardList)throws ServiceException, ServiceDaoException {
		
	
		          	
        log.info(" insert lists : " + (cardList == null ? "null" : cardList.size()));
      
		List<Card> resultList = null;

		if (CollectionUtils.isEmpty(cardList)) {
			return new ArrayList<Card>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Card card : cardList) {
			card.setCreateAt(currentTimeMillis);
			card.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Card>) dao.batchSave(cardList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + cardList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException {
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Card.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Card card)throws ServiceException, ServiceDaoException {
		
	
		          
	log.info(" update data : " + (card == null ? "null" : card.getId()));

		boolean result = false;

		if (card == null) {
			return true;
		}

		card.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(card);
		} catch (DaoException e) {
			log.error(" update wrong : " + card);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + card);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Card> cardList)throws ServiceException, ServiceDaoException {
		
	
		          log.info(" update lists : " + (cardList == null ? "null" : cardList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(cardList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Card card : cardList) {
			card.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(cardList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + cardList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + cardList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Card getObjectById(Long id)throws ServiceException, ServiceDaoException {
		
	
		              
        log.info(" get data : " + id);
      
		Card card = null;

		if (id == null) {
			return card;
		}

		try {
			card = (Card) dao.get(Card.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return card;		
		}	
		  
    	   
		@Override
		public List<Card> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException {
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Card> card = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Card>();
		}

		try {
			card = (List<Card>) dao.getList(Card.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (card == null ? "null" : card.size()));
    
		return card;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCardIdsByStudentIdAndCardSpeciesIdOrderByCreateAt(Long studentId,Long cardSpeciesId,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by studentId,cardSpeciesId,start,limit  : " + studentId+" , "+cardSpeciesId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCardIdsByStudentIdAndCardSpeciesIdOrderByCreateAt", new Object[] { studentId,cardSpeciesId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by studentId,cardSpeciesId,start,limit)  : " + studentId+" , "+cardSpeciesId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCardIdsByStudentIdOrderByCreateAt(Long studentId,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by studentId,start,limit  : " + studentId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCardIdsByStudentIdOrderByCreateAt", new Object[] { studentId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by studentId,start,limit)  : " + studentId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCardIdsByStudentIdAndCardStatusOrderByCreateAt(Long studentId,Integer cardStatus,Integer start,Integer limit)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by studentId,cardStatus,start,limit  : " + studentId+" , "+cardStatus+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCardIdsByStudentIdAndCardStatusOrderByCreateAt", new Object[] { studentId,cardStatus},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by studentId,cardStatus,start,limit)  : " + studentId+" , "+cardStatus+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCardIdsByStudentIdAndCardSpeciesIdOrderByCreateAt(Long studentId,Long cardSpeciesId)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by studentId,cardSpeciesId  : " + studentId+" , "+cardSpeciesId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCardIdsByStudentIdAndCardSpeciesIdOrderByCreateAt", new Object[] { studentId,cardSpeciesId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by studentId,cardSpeciesId)  : " + studentId+" , "+cardSpeciesId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCardIdsByStudentIdOrderByCreateAt(Long studentId)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by studentId  : " + studentId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCardIdsByStudentIdOrderByCreateAt", new Object[] { studentId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by studentId)  : " + studentId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCardIdsByStudentIdAndCardStatusOrderByCreateAt(Long studentId,Integer cardStatus)throws ServiceException, ServiceDaoException {
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by studentId,cardStatus  : " + studentId+" , "+cardStatus );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCardIdsByStudentIdAndCardStatusOrderByCreateAt", new Object[] { studentId,cardStatus});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by studentId,cardStatus)  : " + studentId+" , "+cardStatus );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getCardIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCardIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCardIds() throws ServiceException,
                ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCardIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCardIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

