/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.dbrg.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.dbrg.home.model.UserRole;
import com.ptteng.dbrg.home.service.UserRoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserRoleServiceImpl
extends BaseDaoServiceImpl
implements UserRoleService {
    private static final Log log = LogFactory.getLog(UserRoleServiceImpl.class);

    public Long insert(UserRole userRole) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userRole));
        if (userRole == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userRole.setCreateAt(Long.valueOf(currentTimeMillis));
        userRole.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userRole);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userRole));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserRole> insertList(List<UserRole> userRoleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userRoleList == null ? "null" : Integer.valueOf(userRoleList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userRoleList)) {
            return new ArrayList<UserRole>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserRole userRole : userRoleList) {
            userRole.setCreateAt(Long.valueOf(currentTimeMillis));
            userRole.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userRoleList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userRoleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserRole.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserRole userRole) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userRole == null ? "null" : userRole.getId())));
        boolean result = false;
        if (userRole == null) {
            return true;
        }
        userRole.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userRole);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userRole));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userRole));
        }
        return result;
    }

    public boolean updateList(List<UserRole> userRoleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userRoleList == null ? "null" : Integer.valueOf(userRoleList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userRoleList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserRole userRole : userRoleList) {
            userRole.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userRoleList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userRoleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userRoleList.size()));
        return result;
    }

    public UserRole getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserRole userRole = null;
        if (id == null) {
            return userRole;
        }
        try {
            userRole = (UserRole)this.dao.get(UserRole.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userRole;
    }

    public List<UserRole> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userRole = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserRole>();
        }
        try {
            userRole = this.dao.getList(UserRole.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userRole == null ? "null" : Integer.valueOf(userRole.size()))));
        return userRole;
    }

    public List<Long> getUserRoleIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserRoleIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserRoleIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserRoleIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserRoleIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

