/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.dbrg.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.dbrg.home.model.Post;
import com.ptteng.dbrg.home.service.PostService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostServiceImpl
extends BaseDaoServiceImpl
implements PostService {
    private static final Log log = LogFactory.getLog(PostServiceImpl.class);

    public Long insert(Post post) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + post));
        if (post == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        post.setCreateAt(Long.valueOf(currentTimeMillis));
        post.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)post);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + post));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Post> insertList(List<Post> postList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (postList == null ? "null" : Integer.valueOf(postList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(postList)) {
            return new ArrayList<Post>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Post post : postList) {
            post.setCreateAt(Long.valueOf(currentTimeMillis));
            post.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(postList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + postList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Post.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Post post) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (post == null ? "null" : post.getId())));
        boolean result = false;
        if (post == null) {
            return true;
        }
        post.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)post);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + post));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + post));
        }
        return result;
    }

    public boolean updateList(List<Post> postList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (postList == null ? "null" : Integer.valueOf(postList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(postList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Post post : postList) {
            post.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(postList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + postList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + postList.size()));
        return result;
    }

    public Post getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Post post = null;
        if (id == null) {
            return post;
        }
        try {
            post = (Post)this.dao.get(Post.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return post;
    }

    public List<Post> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List post = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Post>();
        }
        try {
            post = this.dao.getList(Post.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (post == null ? "null" : Integer.valueOf(post.size()))));
        return post;
    }

    public List<Long> getPostIdsByPostRankAndPostTypeOrderByCreateAt(Integer postRank, Integer postType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by postRank,postType,start,limit  : " + postRank + " , " + postType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPostIdsByPostRankAndPostTypeOrderByCreateAt", new Object[]{postRank, postType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by postRank,postType,start,limit)  : " + postRank + " , " + postType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getPostIdsByPostRankAndPostTypeOrderByPubdate(Integer postRank, Integer postType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)"----------------------------------------------------------------------------------------------------");
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by postRank,postType,start,limit  : " + postRank + " , " + postType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPostIdsByPostRankAndPostTypeOrderByPubdate", new Object[]{postRank, postType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by postRank,postType,start,limit)  : " + postRank + " , " + postType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPostIdsByPostRankAndPostTypeOrderByCreateAt(Integer postRank, Integer postType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by postRank,postType  : " + postRank + " , " + postType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPostIdsByPostRankAndPostTypeOrderByCreateAt", new Object[]{postRank, postType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by postRank,postType)  : " + postRank + " , " + postType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countPostIdsByPostRankAndPostTypeOrderByPubdate(Integer postRank, Integer postType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by postRank,postType  : " + postRank + " , " + postType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPostIdsByPostRankAndPostTypeOrderByPubdate", new Object[]{postRank, postType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by postRank,postType)  : " + postRank + " , " + postType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getPostIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPostIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPostIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPostIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPostIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

