/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.dbrg.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.dbrg.home.model.Module;
import com.ptteng.dbrg.home.service.ModuleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModuleServiceImpl
extends BaseDaoServiceImpl
implements ModuleService {
    private static final Log log = LogFactory.getLog(ModuleServiceImpl.class);

    public Long insert(Module module) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + module));
        if (module == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        module.setCreateAt(Long.valueOf(currentTimeMillis));
        module.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)module);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + module));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Module> insertList(List<Module> moduleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (moduleList == null ? "null" : Integer.valueOf(moduleList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(moduleList)) {
            return new ArrayList<Module>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Module module : moduleList) {
            module.setCreateAt(Long.valueOf(currentTimeMillis));
            module.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(moduleList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + moduleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Module.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Module module) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (module == null ? "null" : module.getId())));
        boolean result = false;
        if (module == null) {
            return true;
        }
        module.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)module);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + module));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + module));
        }
        return result;
    }

    public boolean updateList(List<Module> moduleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (moduleList == null ? "null" : Integer.valueOf(moduleList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(moduleList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Module module : moduleList) {
            module.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(moduleList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + moduleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + moduleList.size()));
        return result;
    }

    public Module getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Module module = null;
        if (id == null) {
            return module;
        }
        try {
            module = (Module)this.dao.get(Module.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return module;
    }

    public List<Module> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List module = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Module>();
        }
        try {
            module = this.dao.getList(Module.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (module == null ? "null" : Integer.valueOf(module.size()))));
        return module;
    }

    public List<Long> getModuleIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getModuleIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countModuleIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getModuleIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getModuleIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

