/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.dbrg.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.dbrg.home.model.Banner;
import com.ptteng.dbrg.home.service.BannerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BannerServiceImpl
extends BaseDaoServiceImpl
implements BannerService {
    private static final Log log = LogFactory.getLog(BannerServiceImpl.class);

    public Long insert(Banner banner) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + banner));
        if (banner == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        banner.setCreateAt(Long.valueOf(currentTimeMillis));
        banner.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)banner);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + banner));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Banner> insertList(List<Banner> bannerList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (bannerList == null ? "null" : Integer.valueOf(bannerList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(bannerList)) {
            return new ArrayList<Banner>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Banner banner : bannerList) {
            banner.setCreateAt(Long.valueOf(currentTimeMillis));
            banner.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(bannerList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + bannerList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Banner.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Banner banner) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (banner == null ? "null" : banner.getId())));
        boolean result = false;
        if (banner == null) {
            return true;
        }
        banner.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)banner);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + banner));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + banner));
        }
        return result;
    }

    public boolean updateList(List<Banner> bannerList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (bannerList == null ? "null" : Integer.valueOf(bannerList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(bannerList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Banner banner : bannerList) {
            banner.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(bannerList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + bannerList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + bannerList.size()));
        return result;
    }

    public Banner getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Banner banner = null;
        if (id == null) {
            return banner;
        }
        try {
            banner = (Banner)this.dao.get(Banner.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return banner;
    }

    public List<Banner> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List banner = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Banner>();
        }
        try {
            banner = this.dao.getList(Banner.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (banner == null ? "null" : Integer.valueOf(banner.size()))));
        return banner;
    }

    public Long getBannerIdByTypeOrderBySort(Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by type  : " + type));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getBannerIdByTypeOrderBySort", new Object[]{type});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by type  : " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getBannerIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBannerIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBannerIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBannerIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBannerIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

