/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.EvolveConfig;
import com.sleepycat.persist.evolve.EvolveStats;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.model.EntityModel;
import java.util.Set;

public class EntityStore {
    private Store store;

    public EntityStore(Environment env, String storeName, StoreConfig config) throws DatabaseException, IncompatibleClassException {
        this.store = new Store(env, storeName, config, false);
    }

    public Environment getEnvironment() {
        return this.store.getEnvironment();
    }

    public StoreConfig getConfig() {
        return this.store.getConfig();
    }

    public String getStoreName() {
        return this.store.getStoreName();
    }

    public static Set<String> getStoreNames(Environment env) throws DatabaseException {
        return Store.getStoreNames(env);
    }

    public EntityModel getModel() {
        return this.store.getModel();
    }

    public Mutations getMutations() {
        return this.store.getMutations();
    }

    public <PK, E> PrimaryIndex<PK, E> getPrimaryIndex(Class<PK> primaryKeyClass, Class<E> entityClass) throws DatabaseException {
        return this.store.getPrimaryIndex(primaryKeyClass, primaryKeyClass.getName(), entityClass, entityClass.getName());
    }

    public <SK, PK, E> SecondaryIndex<SK, PK, E> getSecondaryIndex(PrimaryIndex<PK, E> primaryIndex, Class<SK> keyClass, String keyName) throws DatabaseException {
        return this.store.getSecondaryIndex(primaryIndex, primaryIndex.getEntityClass(), primaryIndex.getEntityClass().getName(), keyClass, keyClass.getName(), keyName);
    }

    public <SK, PK, E1, E2 extends E1> SecondaryIndex<SK, PK, E2> getSubclassIndex(PrimaryIndex<PK, E1> primaryIndex, Class<E2> entitySubclass, Class<SK> keyClass, String keyName) throws DatabaseException {
        this.getModel().getClassMetadata(entitySubclass.getName());
        return this.store.getSecondaryIndex(primaryIndex, entitySubclass, primaryIndex.getEntityClass().getName(), keyClass, keyClass.getName(), keyName);
    }

    public EvolveStats evolve(EvolveConfig config) throws DatabaseException {
        return this.store.evolve(config);
    }

    public void truncateClass(Class entityClass) throws DatabaseException {
        this.store.truncateClass(null, entityClass);
    }

    public void truncateClass(Transaction txn, Class entityClass) throws DatabaseException {
        this.store.truncateClass(txn, entityClass);
    }

    public void sync() throws DatabaseException {
        this.store.sync();
    }

    public void closeClass(Class entityClass) throws DatabaseException {
        this.store.closeClass(entityClass);
    }

    public void close() throws DatabaseException {
        this.store.close();
    }

    public Sequence getSequence(String name) throws DatabaseException {
        return this.store.getSequence(name);
    }

    public SequenceConfig getSequenceConfig(String name) {
        return this.store.getSequenceConfig(name);
    }

    public void setSequenceConfig(String name, SequenceConfig config) {
        this.store.setSequenceConfig(name, config);
    }

    public DatabaseConfig getPrimaryConfig(Class entityClass) {
        return this.store.getPrimaryConfig(entityClass);
    }

    public void setPrimaryConfig(Class entityClass, DatabaseConfig config) {
        this.store.setPrimaryConfig(entityClass, config);
    }

    public SecondaryConfig getSecondaryConfig(Class entityClass, String keyName) {
        return this.store.getSecondaryConfig(entityClass, keyName);
    }

    public void setSecondaryConfig(Class entityClass, String keyName, SecondaryConfig config) {
        this.store.setSecondaryConfig(entityClass, keyName, config);
    }
}

